/// <reference path="./internal_*.d.ts" />
declare namespace com.illusivesoulworks.polymorph.mixin.core {
    interface AccessorInventoryMenu {
        abstract getOwner(): Internal.Player;
        abstract getCraftSlots(): Internal.CraftingContainer;
        abstract getResultSlots(): Internal.ResultContainer;
        get owner(): Internal.Player
        get craftSlots(): Internal.CraftingContainer
        get resultSlots(): Internal.ResultContainer
    }
    type AccessorInventoryMenu_ = AccessorInventoryMenu;
}
declare namespace Internal {
    class ClientboundTabListPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: net.minecraft.network.chat.Component_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getFooter(): net.minecraft.network.chat.Component;
        getHeader(): net.minecraft.network.chat.Component;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get footer(): net.minecraft.network.chat.Component
        get header(): net.minecraft.network.chat.Component
        get skippable(): boolean
    }
    type ClientboundTabListPacket_ = ClientboundTabListPacket;
    class PistonHeadBlock extends Internal.DirectionalBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly TYPE: Internal.EnumProperty<Internal.PistonType>;
        static readonly SHORT: Internal.BooleanProperty;
        static readonly PLATFORM: 4.0;
    }
    type PistonHeadBlock_ = PistonHeadBlock;
    class InsideWorldBoundsPredicate implements net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate {
        constructor($$0: Vec3i_)
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        type(): Internal.BlockPredicateType<any>;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        test(arg0: any, arg1: any): boolean;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.InsideWorldBoundsPredicate>;
    }
    type InsideWorldBoundsPredicate_ = InsideWorldBoundsPredicate;
    class MethodHandles$Lookup {
        /**
         * @deprecated
        */
        hasPrivateAccess(): boolean;
        hasFullPrivilegeAccess(): boolean;
        findVarHandle(arg0: typeof any, arg1: string, arg2: typeof any): Internal.VarHandle;
        accessClass<T>(arg0: T): T;
        unreflectSetter(arg0: Internal.Field_): Internal.MethodHandle;
        unreflectConstructor(arg0: Internal.Constructor_<any>): Internal.MethodHandle;
        findStaticVarHandle(arg0: typeof any, arg1: string, arg2: typeof any): Internal.VarHandle;
        findClass(arg0: string): typeof any;
        unreflect(arg0: Internal.Method_): Internal.MethodHandle;
        findGetter(arg0: typeof any, arg1: string, arg2: typeof any): Internal.MethodHandle;
        findSetter(arg0: typeof any, arg1: string, arg2: typeof any): Internal.MethodHandle;
        findConstructor(arg0: typeof any, arg1: Internal.MethodType_): Internal.MethodHandle;
        dropLookupMode(arg0: number): this;
        defineHiddenClassWithClassData(arg0: number[], arg1: any, arg2: boolean, ...arg3: any_[]): this;
        unreflectSpecial(arg0: Internal.Method_, arg1: typeof any): Internal.MethodHandle;
        ensureInitialized<T>(arg0: T): T;
        "in"(arg0: typeof any): this;
        lookupClass(): typeof any;
        findStaticSetter(arg0: typeof any, arg1: string, arg2: typeof any): Internal.MethodHandle;
        previousLookupClass(): typeof any;
        unreflectVarHandle(arg0: Internal.Field_): Internal.VarHandle;
        unreflectGetter(arg0: Internal.Field_): Internal.MethodHandle;
        findSpecial(arg0: typeof any, arg1: string, arg2: Internal.MethodType_, arg3: typeof any): Internal.MethodHandle;
        bind(arg0: any, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        lookupModes(): number;
        defineClass(arg0: number[]): typeof any;
        findVirtual(arg0: typeof any, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        findStatic(arg0: typeof any, arg1: string, arg2: Internal.MethodType_): Internal.MethodHandle;
        findStaticGetter(arg0: typeof any, arg1: string, arg2: typeof any): Internal.MethodHandle;
        revealDirect(arg0: Internal.MethodHandle_): Internal.MethodHandleInfo;
        defineHiddenClass(arg0: number[], arg1: boolean, ...arg2: any_[]): this;
        static readonly PACKAGE: 8;
        static readonly PUBLIC: 1;
        static readonly UNCONDITIONAL: 32;
        static readonly MODULE: 16;
        static readonly ORIGINAL: 64;
        static readonly PRIVATE: 2;
        static readonly PROTECTED: 4;
    }
    type MethodHandles$Lookup_ = MethodHandles$Lookup;
    class ServerConnectionListener {
        constructor($$0: Internal.MinecraftServer_)
        stop(): void;
        startMemoryChannel(): Internal.SocketAddress;
        tick(): void;
        startTcpServerListener($$0: Internal.InetAddress_, $$1: number): void;
        getConnections(): Internal.List<Internal.Connection>;
        getServer(): Internal.MinecraftServer;
        get connections(): Internal.List<Internal.Connection>
        get server(): Internal.MinecraftServer
        static readonly SERVER_EPOLL_EVENT_GROUP: Internal.LazyLoadedValue<Internal.EpollEventLoopGroup>;
        running: boolean;
        static readonly SERVER_EVENT_GROUP: Internal.LazyLoadedValue<Internal.NioEventLoopGroup>;
    }
    type ServerConnectionListener_ = ServerConnectionListener;
    class ByteArrayTag extends Internal.CollectionTag<Internal.ByteTag> {
        constructor($$0: Internal.List_<number>)
        constructor($$0: number[])
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        getType(): Internal.TagType<Internal.ByteArrayTag>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        parallelStream(): Internal.Stream<Internal.ByteTag>;
        set(arg0: number, arg1: Internal.Tag_): Internal.Tag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        sort(arg0: Internal.Comparator_<Internal.ByteTag>): void;
        set($$0: number, $$1: Internal.ByteTag_): Internal.ByteTag;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        addLast(arg0: Internal.ByteTag_): void;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        getAsByteArray(): number[];
        reversed(): Internal.SequencedCollection<any>;
        removeIf(arg0: Internal.Predicate_<Internal.ByteTag>): boolean;
        removeLast(): Internal.ByteTag;
        spliterator(): Internal.Spliterator<Internal.ByteTag>;
        stream(): Internal.Stream<Internal.ByteTag>;
        replaceAll(arg0: Internal.UnaryOperator_<Internal.ByteTag>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        getFirst(): Internal.ByteTag;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        forEach(arg0: Internal.Consumer_<Internal.ByteTag>): void;
        abstract toArray<T>(arg0: T[]): T[];
        remove(arg0: number): Internal.Tag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        get(arg0: number): any;
        add($$0: number, $$1: Internal.ByteTag_): void;
        remove($$0: number): Internal.ByteTag;
        getAsString(): string;
        addFirst(arg0: Internal.ByteTag_): void;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        getLast(): Internal.ByteTag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        removeFirst(): Internal.ByteTag;
        get($$0: number): Internal.ByteTag;
        get type(): Internal.TagType<Internal.ByteArrayTag>
        get asByteArray(): number[]
        get first(): Internal.ByteTag
        get asString(): string
        get last(): Internal.ByteTag
        static readonly TYPE: Internal.TagType<Internal.ByteArrayTag>;
    }
    type ByteArrayTag_ = ByteArrayTag;
    class BlockEntitySlipway extends Internal.HexBlockEntity {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        tick(level: Internal.Level_, blockPos: BlockPos_): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getPos(): BlockPos;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static access$getRANDOM$cp(): Internal.Random;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get pos(): BlockPos
        static readonly SPAWN_INTERVAL_MU: 80;
        static readonly RENDER_RADIUS: 0.5;
        static readonly TAG_IS_ACTIVE: "is_active";
        static readonly TAG_NEXT_SPAWN_TICK: "last_spawned_tick";
        static readonly ACTIVE_RANGE: 5.0;
        static readonly SPAWN_INTERVAL_SIG: 10;
        static readonly Companion: Internal.BlockEntitySlipway$Companion;
    }
    type BlockEntitySlipway_ = BlockEntitySlipway;
    class LavaCauldronBlock extends Internal.AbstractCauldronBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type LavaCauldronBlock_ = LavaCauldronBlock;
    interface ToDoubleBiFunction <T, U> {
        abstract applyAsDouble(arg0: T, arg1: U): number;
        (arg0: T, arg1: U): number;
    }
    type ToDoubleBiFunction_<T, U> = ToDoubleBiFunction<T, U>;
    class SmartFluidTank extends io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank {
        constructor(capacity: number, updateCallback: Internal.Consumer_<Internal.FluidStack>)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getResource(): any;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsInsertion(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        static asClass<T>(): Internal.Storage<T>;
        getUnderlyingView(): Internal.StorageView<Internal.FluidVariant>;
        supportsExtraction(): boolean;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.FluidVariant>;
        getSlotCount(): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        setFluid(stack: Internal.FluidStack_, ctx: Internal.TransactionContext_): void;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        get resource(): any
        get underlyingView(): Internal.StorageView<Internal.FluidVariant>
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>
        get version(): number
    }
    type SmartFluidTank_ = SmartFluidTank;
    class MoltenMercuryFluid$Flowing extends Internal.MoltenMercuryFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenMercuryFluid$Flowing_ = MoltenMercuryFluid$Flowing;
    interface IFluidContainer extends Internal.IEmptyContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract getFluid(): Internal.Fluid;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        /**
         * @deprecated
        */
        get empty(): boolean
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        get fluid(): Internal.Fluid
        (): Internal.Fluid_;
    }
    type IFluidContainer_ = IFluidContainer;
    class RottenTomatoItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RottenTomatoItem_ = RottenTomatoItem;
    interface BlockBehaviour$OffsetFunction {
        abstract evaluate(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Vec3d;
        (arg0: Internal.BlockState, arg1: Internal.BlockGetter, arg2: BlockPos): Vec3d_;
    }
    type BlockBehaviour$OffsetFunction_ = BlockBehaviour$OffsetFunction;
    class TableBlockItem extends Internal.RetexturedBlockItem {
        constructor(block: Internal.Block_, textureTag: Internal.TagKey_<Internal.Item>, builder: Internal.Item$Properties_, showAllCondition: Internal.BooleanSupplier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TableBlockItem_ = TableBlockItem;
    interface AkashicFloodfiller {
        canItBeFloodedThrough(pos: BlockPos_, state: Internal.BlockState_, world: Internal.Level_): boolean;
        floodFillFor(start: BlockPos_, world: Internal.Level_, isTarget: Internal.TriPredicate_<BlockPos, Internal.BlockState, Internal.Level>): BlockPos;
        canBeFloodedThrough(pos: BlockPos_, state: Internal.BlockState_, world: Internal.Level_): boolean;
        floodFillFor(start: BlockPos_, world: Internal.Level_, skipChance: number, isTarget: Internal.TriPredicate_<BlockPos, Internal.BlockState, Internal.Level>, maxRange: number): BlockPos;
    }
    type AkashicFloodfiller_ = AkashicFloodfiller;
    class TinkersAnvilBlock extends Internal.TinkerStationBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, slotCount: number)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TinkersAnvilBlock_ = TinkersAnvilBlock;
    class ItemChain extends Internal.Item {
        constructor(sticky: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static attachToFence(player: Internal.Player_, worldIn: Internal.Level_, fence: BlockPos_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemChain_ = ItemChain;
    class BlockState extends Internal.BlockBehaviour$BlockStateBase implements io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockStateExtensions, Internal.BlockStateFTBC, Internal.BaseBlockStateExtension, Internal.SophisticatedBlockState, Internal.BlockStateExtensions, Internal.FabricBlockState {
        constructor($$0: Internal.Block_, $$1: Internal.ImmutableMap_<Internal.Property<any>, Internal.Comparable<any>>, $$2: Internal.MapCodec_<Internal.BlockState>)
        addHitEffects(level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        canSustainPlant(level: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addDestroyEffects(level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getStateAtViewpoint(level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): this;
        getToolModifiedState(context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): this;
        getFTBCIsWater(): boolean;
        canEntityDestroy(level: Internal.BlockGetter_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): this;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        supportsExternalFaceHiding(): boolean;
        getAppearance(renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): this;
        addRunningEffects(level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        onTreeGrow(level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        isSlimeBlock(): boolean;
        isStickyBlock(): boolean;
        getBeaconColorMultiplier(level: Internal.LevelReader_, pos: BlockPos_, beacon: BlockPos_): number[];
        onDestroyedByPlayer(level: Internal.Level_, pos: BlockPos_, player: Internal.Player_, willHarvest: boolean, fluid: Internal.FluidState_): boolean;
        canStickTo(other: Internal.BlockState_): boolean;
        addLandingEffects(level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        get FTBCIsWater(): boolean
        get slimeBlock(): boolean
        get stickyBlock(): boolean
        static readonly CODEC: Internal.Codec<Internal.BlockState>;
    }
    type BlockState_ = BlockState;
    class ClientboundSetPlayerTeamPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        static createAddOrModifyPacket($$0: Internal.PlayerTeam_, $$1: boolean): Internal.ClientboundSetPlayerTeamPacket;
        getTeamAction(): Internal.ClientboundSetPlayerTeamPacket$Action;
        write($$0: Internal.FriendlyByteBuf_): void;
        static createPlayerPacket($$0: Internal.PlayerTeam_, $$1: string, $$2: Internal.ClientboundSetPlayerTeamPacket$Action_): Internal.ClientboundSetPlayerTeamPacket;
        static createRemovePacket($$0: Internal.PlayerTeam_): Internal.ClientboundSetPlayerTeamPacket;
        getPlayerAction(): Internal.ClientboundSetPlayerTeamPacket$Action;
        getName(): string;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getParameters(): Internal.Optional<Internal.ClientboundSetPlayerTeamPacket$Parameters>;
        isSkippable(): boolean;
        getPlayers(): Internal.Collection<string>;
        get teamAction(): Internal.ClientboundSetPlayerTeamPacket$Action
        get playerAction(): Internal.ClientboundSetPlayerTeamPacket$Action
        get name(): string
        get parameters(): Internal.Optional<Internal.ClientboundSetPlayerTeamPacket$Parameters>
        get skippable(): boolean
        get players(): Internal.Collection<string>
    }
    type ClientboundSetPlayerTeamPacket_ = ClientboundSetPlayerTeamPacket;
    interface RecordBuilder <T> {
        build(arg0: Internal.DataResult_<T>): Internal.DataResult<T>;
        abstract add(arg0: T, arg1: Internal.DataResult_<T>): this;
        abstract setLifecycle(arg0: Internal.Lifecycle_): this;
        add<E>(arg0: string, arg1: E, arg2: Internal.Encoder_<E>): this;
        abstract withErrorsFrom(arg0: Internal.DataResult_<any>): this;
        abstract add(arg0: Internal.DataResult_<T>, arg1: Internal.DataResult_<T>): this;
        abstract add(arg0: T, arg1: T): this;
        abstract ops(): Internal.DynamicOps<T>;
        add(arg0: string, arg1: T): this;
        add(arg0: string, arg1: Internal.DataResult_<T>): this;
        abstract build(arg0: T): Internal.DataResult<T>;
        abstract mapError(arg0: Internal.UnaryOperator_<string>): this;
        set lifecycle(arg0: Internal.Lifecycle_)
    }
    type RecordBuilder_<T> = RecordBuilder<T>;
    class Panda extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Panda>, $$1: Internal.Level_)
        eat($$0: boolean): void;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getMainGene(): Internal.Panda$Gene;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isSneezing(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setSneezeCounter($$0: number): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getSneezeCounter(): number;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        isScared(): boolean;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        sneeze($$0: boolean): void;
        canRiderInteract(): boolean;
        isRolling(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        getHiddenGene(): Internal.Panda$Gene;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setOnBack($$0: boolean): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isEating(): boolean;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        setAttributes(): void;
        getType(): string;
        getSitAmount($$0: number): number;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        canPerformAction(): boolean;
        getLieOnBackAmount($$0: number): number;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        setMainGene($$0: Internal.Panda$Gene_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        isBrown(): boolean;
        isOnBack(): boolean;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        getUnhappyCounter(): number;
        setGeneFromParents($$0: Internal.Panda_, $$1: Internal.Panda_): void;
        sit($$0: boolean): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        roll($$0: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        isWeak(): boolean;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        isPlayful(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        setHiddenGene($$0: Internal.Panda$Gene_): void;
        setUnhappyCounter($$0: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        isLazy(): boolean;
        getVariant(): Internal.Panda$Gene;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        isSitting(): boolean;
        getRollAmount($$0: number): number;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        isWorried(): boolean;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get mainGene(): Internal.Panda$Gene
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get sneezing(): boolean
        set sneezeCounter($$0: number)
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get sneezeCounter(): number
        get teamId(): string
        get scared(): boolean
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get rolling(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get hiddenGene(): Internal.Panda$Gene
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set onBack($$0: boolean)
        get undead(): boolean
        get eating(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set mainGene($$0: Internal.Panda$Gene_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get brown(): boolean
        get onBack(): boolean
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get unhappyCounter(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get weak(): boolean
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get playful(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        set hiddenGene($$0: Internal.Panda$Gene_)
        set unhappyCounter($$0: number)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get lazy(): boolean
        get variant(): Internal.Panda$Gene
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get sitting(): boolean
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        get worried(): boolean
        static readonly TOTAL_ROLL_STEPS: 32;
        rollCounter: number;
    }
    type Panda_ = Panda;
    class CarriageContraption extends Internal.Contraption {
        constructor()
        constructor(assemblyDirection: Internal.Direction_)
        swapStorageAfterAssembly(cce: Internal.CarriageContraptionEntity_): void;
        inControl(pos: BlockPos_, direction: Internal.Direction_): boolean;
        withinVisible(localPos: BlockPos_): boolean;
        hasBackwardControls(): boolean;
        setSoundQueueOffset(offset: number): void;
        getSecondBogeyPos(): BlockPos;
        withinVisible(posAlongMovementAxis: number): boolean;
        atSeam(localPos: BlockPos_): boolean;
        returnStorageForDisassembly(storage: Internal.MountedStorageManager_): void;
        isHiddenInPortal(posAlongMovementAxis: number): boolean;
        notInPortal(): boolean;
        atSeam(posAlongMovementAxis: number): boolean;
        getAssemblyDirection(): Internal.Direction;
        hasForwardControls(): boolean;
        set soundQueueOffset(offset: number)
        get secondBogeyPos(): BlockPos
        get assemblyDirection(): Internal.Direction
        soundQueue: Internal.ArrivalSoundQueue;
        blockConductors: Internal.Couple<boolean>;
        portalCutoffMin: number;
        portalCutoffMax: number;
        conductorSeats: Internal.Map<BlockPos, Internal.Couple<boolean>>;
    }
    type CarriageContraption_ = CarriageContraption;
    class ModifierSetWorktableRecipe extends Internal.AbstractWorktableRecipe {
        constructor(id: ResourceLocation_, dataKey: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, blacklist: Internal.TagKey_<Internal.Modifier>, addToSet: boolean)
        constructor(id: ResourceLocation_, dataKey: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, modifierPredicate: any_<Internal.ModifierId>, addToSet: boolean)
        constructor(id: ResourceLocation_, dataKey: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, toolRequirement: Internal.Ingredient_, modifierPredicate: any_<Internal.ModifierId>, addToSet: boolean, allowTraits: boolean)
        getGroup(): string;
        updateInputs(result: Internal.IToolStackView_, inv: Internal.ITinkerableContainer$Mutable_, selected: Internal.ModifierEntry_, isServer: boolean): void;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        toolResultSize(): number;
        /**
         * @deprecated
        */
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ITinkerableContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        toolResultSize(inv: Internal.ITinkerableContainer_, selected: Internal.ModifierEntry_): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        static isInSet(modData: Internal.IModDataView_, key: ResourceLocation_, modifier: Internal.ModifierId_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        isModifierOutput(): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        static getModifierSet(modData: Internal.IModDataView_, key: ResourceLocation_): Internal.Set<Internal.ModifierId>;
        getRemainingItems($$0: Internal.ITinkerableContainer_): Internal.NonNullList<Internal.ItemStack>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get modifierOutput(): boolean
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type ModifierSetWorktableRecipe_ = ModifierSetWorktableRecipe;
    class AssemblerAnimationStatus {
        constructor(speed: number, is: Internal.ItemStack_)
        getSpeed(): number;
        getIs(): Internal.ItemStack;
        getTicksUntilParticles(): number;
        isExpired(): boolean;
        setTicksUntilParticles(ticksUntilParticles: number): void;
        getAccumulatedTicks(): number;
        setAccumulatedTicks(accumulatedTicks: number): void;
        get speed(): number
        get is(): Internal.ItemStack
        get ticksUntilParticles(): number
        get expired(): boolean
        set ticksUntilParticles(ticksUntilParticles: number)
        get accumulatedTicks(): number
        set accumulatedTicks(accumulatedTicks: number)
    }
    type AssemblerAnimationStatus_ = AssemblerAnimationStatus;
    class SpectatorPage {
        constructor($$0: Internal.List_<Internal.SpectatorMenuItem>, $$1: number)
        getSelectedSlot(): number;
        getItem($$0: number): Internal.SpectatorMenuItem;
        get selectedSlot(): number
        static readonly NO_SELECTION: -1;
    }
    type SpectatorPage_ = SpectatorPage;
    interface EntityEvents$JoinWorld {
        abstract onJoinWorld(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: boolean): boolean;
        (arg0: Internal.Entity, arg1: Internal.Level, arg2: boolean): boolean;
    }
    type EntityEvents$JoinWorld_ = EntityEvents$JoinWorld;
    class CartAssemblerBlock$CartAssemblerAction extends Internal.Enum<Internal.CartAssemblerBlock$CartAssemblerAction> {
        static valueOf(name: string): Internal.CartAssemblerBlock$CartAssemblerAction;
        shouldDisassemble(): boolean;
        static values(): Internal.CartAssemblerBlock$CartAssemblerAction[];
        shouldAssemble(): boolean;
        static readonly DISASSEMBLE_BRAKE: Internal.CartAssemblerBlock$CartAssemblerAction;
        static readonly ASSEMBLE_ACCELERATE_DIRECTIONAL: Internal.CartAssemblerBlock$CartAssemblerAction;
        static readonly ASSEMBLE_ACCELERATE: Internal.CartAssemblerBlock$CartAssemblerAction;
        static readonly PASS: Internal.CartAssemblerBlock$CartAssemblerAction;
        static readonly DISASSEMBLE: Internal.CartAssemblerBlock$CartAssemblerAction;
        static readonly ASSEMBLE: Internal.CartAssemblerBlock$CartAssemblerAction;
    }
    type CartAssemblerBlock$CartAssemblerAction_ = "disassemble_brake" | "pass" | "disassemble" | "assemble" | "assemble_accelerate" | CartAssemblerBlock$CartAssemblerAction | "assemble_accelerate_directional";
    interface RandomBlockMatchTestAccessor {
        abstract getProbability(): number;
        abstract getBlock(): Internal.Block;
        get probability(): number
        get block(): Internal.Block
    }
    type RandomBlockMatchTestAccessor_ = RandomBlockMatchTestAccessor;
    class PalmTreeConfiguration extends Internal.BOPTreeConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.PalmTreeConfiguration>;
    }
    type PalmTreeConfiguration_ = PalmTreeConfiguration;
    class EntityArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.EntityArgument> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.EntityArgument;
        type(): Internal.ArgumentTypeInfo<Internal.EntityArgument, any>;
    }
    type EntityArgument$Info$Template_ = EntityArgument$Info$Template;
    interface ClampedItemPropertyFunction extends Internal.ItemPropertyFunction {
        /**
         * @deprecated
        */
        call($$0: Internal.ItemStack_, $$1: Internal.ClientLevel_, $$2: Internal.LivingEntity_, $$3: number): number;
        abstract unclampedCall(arg0: Internal.ItemStack_, arg1: Internal.ClientLevel_, arg2: Internal.LivingEntity_, arg3: number): number;
        (arg0: Internal.ItemStack, arg1: Internal.ClientLevel, arg2: Internal.LivingEntity, arg3: number): number;
    }
    type ClampedItemPropertyFunction_ = ClampedItemPropertyFunction;
    class StructureTemplate implements Internal.StructureTemplateAccessor, Internal.StructureTemplateExtensions {
        constructor()
        getAuthor(): string;
        placeInWorld($$0: Internal.ServerLevelAccessor_, $$1: BlockPos_, $$2: BlockPos_, $$3: Internal.StructurePlaceSettings_, $$4: Internal.RandomSource_, $$5: number): boolean;
        transformedVec3d(settings: Internal.StructurePlaceSettings_, pos: Vec3d_): Vec3d;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        filterBlocks($$0: BlockPos_, $$1: Internal.StructurePlaceSettings_, $$2: Internal.Block_): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
        handler$zla000$ae2$disableClientSideStateSaving(ci: Internal.CallbackInfo_): void;
        getSize(): Vec3i;
        static calculateRelativePosition($$0: Internal.StructurePlaceSettings_, $$1: BlockPos_): BlockPos;
        getZeroPositionWithTransform($$0: BlockPos_, $$1: Internal.Mirror_, $$2: Internal.Rotation_): BlockPos;
        handler$zla000$ae2$enableClientSideStateSaving(ci: Internal.CallbackInfo_): void;
        calculateConnectedPosition($$0: Internal.StructurePlaceSettings_, $$1: BlockPos_, $$2: Internal.StructurePlaceSettings_, $$3: BlockPos_): BlockPos;
        load($$0: Internal.HolderGetter_<Internal.Block>, $$1: Internal.CompoundTag_): void;
        setAuthor($$0: string): void;
        static port_lib$createEntityIgnoreException(iServerWorld: Internal.ServerLevelAccessor_, compoundNBT: Internal.CompoundTag_): Internal.Optional<Internal.Entity>;
        static processBlockInfos($$0: Internal.ServerLevelAccessor_, $$1: BlockPos_, $$2: BlockPos_, $$3: Internal.StructurePlaceSettings_, $$4: Internal.List_<Internal.StructureTemplate$StructureBlockInfo>): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
        static transform($$0: Vec3d_, $$1: Internal.Mirror_, $$2: Internal.Rotation_, $$3: BlockPos_): Vec3d;
        getSize($$0: Internal.Rotation_): Vec3i;
        addEntitiesToWorld(level: Internal.ServerLevelAccessor_, pos: BlockPos_, settings: Internal.StructurePlaceSettings_): void;
        getBoundingBox($$0: BlockPos_, $$1: Internal.Rotation_, $$2: BlockPos_, $$3: Internal.Mirror_): Internal.BoundingBox;
        static port_lib$createEntityIgnoreException$porting_lib_accessors_$md$fca01f$0(arg0: Internal.ServerLevelAccessor_, arg1: Internal.CompoundTag_): Internal.Optional<any>;
        static updateShapeAtEdge($$0: Internal.LevelAccessor_, $$1: number, $$2: Internal.DiscreteVoxelShape_, $$3: number, $$4: number, $$5: number): void;
        filterBlocks($$0: BlockPos_, $$1: Internal.StructurePlaceSettings_, $$2: Internal.Block_, $$3: boolean): Internal.ObjectArrayList<Internal.StructureTemplate$StructureBlockInfo>;
        static transform($$0: BlockPos_, $$1: Internal.Mirror_, $$2: Internal.Rotation_, $$3: BlockPos_): BlockPos;
        static getZeroPositionWithTransform($$0: BlockPos_, $$1: Internal.Mirror_, $$2: Internal.Rotation_, $$3: number, $$4: number): BlockPos;
        processEntityInfos(template: Internal.StructureTemplate_, world: Internal.LevelAccessor_, blockPos: BlockPos_, settings: Internal.StructurePlaceSettings_, infos: Internal.List_<any>): Internal.List<any>;
        getEntities(): Internal.List<any>;
        getBoundingBox($$0: Internal.StructurePlaceSettings_, $$1: BlockPos_): Internal.BoundingBox;
        fillFromWorld($$0: Internal.Level_, $$1: BlockPos_, $$2: Vec3i_, $$3: boolean, $$4: Internal.Block_): void;
        get author(): string
        get size(): Vec3i
        set author($$0: string)
        get entities(): Internal.List<any>
        static readonly BLOCK_TAG_POS: "pos";
        static readonly ENTITY_TAG_POS: "pos";
        static readonly PALETTE_LIST_TAG: "palettes";
        static readonly BLOCKS_TAG: "blocks";
        static readonly ENTITY_TAG_NBT: "nbt";
        static readonly ENTITY_TAG_BLOCKPOS: "blockPos";
        static readonly BLOCK_TAG_STATE: "state";
        static readonly BLOCK_TAG_NBT: "nbt";
        static readonly SIZE_TAG: "size";
        static readonly PALETTE_TAG: "palette";
        static readonly ENTITIES_TAG: "entities";
        readonly palettes: Internal.List<Internal.StructureTemplate$Palette>;
    }
    type StructureTemplate_ = StructureTemplate;
    class BiomeSpecialEffects {
        getWaterColor(): number;
        getAmbientParticleSettings(): Internal.Optional<Internal.AmbientParticleSettings>;
        getAmbientAdditionsSettings(): Internal.Optional<Internal.AmbientAdditionsSettings>;
        getGrassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier;
        getBackgroundMusic(): Internal.Optional<Internal.Music>;
        getWaterFogColor(): number;
        getAmbientLoopSoundEvent(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>;
        getGrassColorOverride(): Internal.Optional<number>;
        getFoliageColorOverride(): Internal.Optional<number>;
        getFogColor(): number;
        getSkyColor(): number;
        getAmbientMoodSettings(): Internal.Optional<Internal.AmbientMoodSettings>;
        get waterColor(): number
        get ambientParticleSettings(): Internal.Optional<Internal.AmbientParticleSettings>
        get ambientAdditionsSettings(): Internal.Optional<Internal.AmbientAdditionsSettings>
        get grassColorModifier(): Internal.BiomeSpecialEffects$GrassColorModifier
        get backgroundMusic(): Internal.Optional<Internal.Music>
        get waterFogColor(): number
        get ambientLoopSoundEvent(): Internal.Optional<Internal.Holder<Internal.SoundEvent>>
        get grassColorOverride(): Internal.Optional<number>
        get foliageColorOverride(): Internal.Optional<number>
        get fogColor(): number
        get skyColor(): number
        get ambientMoodSettings(): Internal.Optional<Internal.AmbientMoodSettings>
        ambientParticleSettings: Internal.Optional<Internal.AmbientParticleSettings>;
        grassColorOverride: Internal.Optional<number>;
        ambientMoodSettings: Internal.Optional<Internal.AmbientMoodSettings>;
        waterColor: number;
        ambientLoopSoundEvent: Internal.Optional<Internal.Holder<Internal.SoundEvent>>;
        fogColor: number;
        ambientAdditionsSettings: Internal.Optional<Internal.AmbientAdditionsSettings>;
        backgroundMusic: Internal.Optional<Internal.Music>;
        grassColorModifier: Internal.BiomeSpecialEffects$GrassColorModifier;
        waterFogColor: number;
        static readonly CODEC: Internal.Codec<Internal.BiomeSpecialEffects>;
        foliageColorOverride: Internal.Optional<number>;
        skyColor: number;
    }
    type BiomeSpecialEffects_ = BiomeSpecialEffects;
    interface IHaveCustomOverlayIcon {
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
    }
    type IHaveCustomOverlayIcon_ = IHaveCustomOverlayIcon;
    class FilteredText extends Internal.Record {
        constructor($$0: string, $$1: Internal.FilterMask_)
        static passThrough($$0: string): Internal.FilteredText;
        raw(): string;
        static fullyFiltered($$0: string): Internal.FilteredText;
        filteredOrEmpty(): string;
        isFiltered(): boolean;
        mask(): Internal.FilterMask;
        filtered(): string;
        get filtered(): boolean
        static readonly EMPTY: Internal.FilteredText;
    }
    type FilteredText_ = FilteredText;
    class DiamondPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type DiamondPipeBlock_ = DiamondPipeBlock;
    class AzaleaBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type AzaleaBlock_ = AzaleaBlock;
    interface EntityEvents$EyeHeight {
        abstract onEntitySize(arg0: Internal.Entity_, arg1: number): number;
        (arg0: Internal.Entity, arg1: number): number;
    }
    type EntityEvents$EyeHeight_ = EntityEvents$EyeHeight;
    class QuartzPickaxeItem extends Internal.PickaxeItem {
        constructor(props: Internal.Item$Properties_, type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzPickaxeItem_ = QuartzPickaxeItem;
    class LevelExtensions$LevelSnapshotData extends Internal.Record {
        constructor(changedStates: Internal.List_<Internal.LevelExtensions$ChangedPosData>)
        changedStates(): Internal.List<Internal.LevelExtensions$ChangedPosData>;
    }
    type LevelExtensions$LevelSnapshotData_ = LevelExtensions$LevelSnapshotData;
    class ScrollOptionBehaviour <E extends Internal.Enum<E> & Internal.INamedIconOptions> extends Internal.ScrollValueBehaviour {
        constructor(enum_: E, label: net.minecraft.network.chat.Component_, be: Internal.SmartBlockEntity_, slot: Internal.ValueBoxTransform_)
        get(): E;
        mayInteract(player: Internal.Player_): boolean;
        bypassesInput(mainhandItem: Internal.ItemStack_): boolean;
        readFromClipboard(tag: Internal.CompoundTag_, player: Internal.Player_, side: Internal.Direction_, simulate: boolean): boolean;
        acceptsValueSettings(): boolean;
        netId(): number;
        writeToClipboard(tag: Internal.CompoundTag_, side: Internal.Direction_): boolean;
        newSettingHovered(valueSetting: Internal.ValueSettingsBehaviour$ValueSettings_): void;
        playFeedbackSound(origin: Internal.BlockEntityBehaviour_): void;
    }
    type ScrollOptionBehaviour_<E extends Internal.Enum<E> & Internal.INamedIconOptions> = ScrollOptionBehaviour<E>;
    abstract class BaseEntityBlock extends Internal.Block implements Internal.EntityBlock {
        abstract newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BaseEntityBlock_ = BaseEntityBlock;
    class BorderStatus extends Internal.Enum<Internal.BorderStatus> {
        getColor(): number;
        static valueOf($$0: string): Internal.BorderStatus;
        static values(): Internal.BorderStatus[];
        get color(): number
        static readonly STATIONARY: Internal.BorderStatus;
        static readonly SHRINKING: Internal.BorderStatus;
        static readonly GROWING: Internal.BorderStatus;
    }
    type BorderStatus_ = "shrinking" | "stationary" | BorderStatus | "growing";
    class PartRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.PartRecipe> {
        constructor()
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.PartRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type PartRecipe$Serializer_ = PartRecipe$Serializer;
    class TwistingVinesFeature extends Internal.Feature<Internal.TwistingVinesConfig> {
        constructor($$0: Internal.Codec_<Internal.TwistingVinesConfig>)
        static placeWeepingVinesColumn($$0: Internal.LevelAccessor_, $$1: Internal.RandomSource_, $$2: Internal.BlockPos$MutableBlockPos_, $$3: number, $$4: number, $$5: number): void;
    }
    type TwistingVinesFeature_ = TwistingVinesFeature;
    interface ValueLayout$OfByte extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type ValueLayout$OfByte_ = ValueLayout$OfByte;
    interface SmithingTrimRecipeAccessor {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type SmithingTrimRecipeAccessor_ = SmithingTrimRecipeAccessor;
    abstract class UpgradeItemBase <T extends Internal.IUpgradeWrapper> extends Internal.ItemBase implements Internal.IUpgradeItem<T> {
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        abstract getUpgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        abstract getType(): Internal.UpgradeType<T>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getName(): net.minecraft.network.chat.Component;
        getInventoryColumnsTaken(): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getUpgradesInGroupPerStorage(storageType: string): number;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getUpgradesPerStorage(storageType: string): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        get upgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>
        set attackSpeed(attackSpeed: number)
        get type(): Internal.UpgradeType<T>
        get name(): net.minecraft.network.chat.Component
        get inventoryColumnsTaken(): number
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type UpgradeItemBase_<T extends Internal.IUpgradeWrapper> = UpgradeItemBase<T>;
    interface FileFilter {
        abstract accept(arg0: Internal.File_): boolean;
        (arg0: Internal.File): boolean;
    }
    type FileFilter_ = FileFilter;
    abstract class CommandNode <S> implements Internal.Comparable<Internal.CommandNode<S>> {
        getRelevantNodes(arg0: Internal.StringReader_): Internal.Collection<Internal.CommandNode<S>>;
        abstract parse(arg0: Internal.StringReader_, arg1: Internal.CommandContextBuilder_<S>): void;
        abstract createBuilder(): Internal.ArgumentBuilder<S, any>;
        canUse(arg0: S): boolean;
        abstract listSuggestions(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        abstract getUsageText(): string;
        compareTo(arg0: any): number;
        getRedirectModifier(): Internal.RedirectModifier<S>;
        getRequirement(): Internal.Predicate<S>;
        abstract getExamples(): Internal.Collection<string>;
        addChild(arg0: Internal.CommandNode_<S>): void;
        abstract getName(): string;
        compareTo(arg0: Internal.CommandNode_<S>): number;
        getRedirect(): this;
        getChild(arg0: string): this;
        isFork(): boolean;
        findAmbiguities(arg0: Internal.AmbiguityConsumer_<S>): void;
        getCommand(): Internal.Command<S>;
        getChildren(): Internal.Collection<Internal.CommandNode<S>>;
        get usageText(): string
        get redirectModifier(): Internal.RedirectModifier<S>
        get requirement(): Internal.Predicate<S>
        get examples(): Internal.Collection<string>
        get name(): string
        get redirect(): Internal.CommandNode<S>
        get fork(): boolean
        get command(): Internal.Command<S>
        get children(): Internal.Collection<Internal.CommandNode<S>>
    }
    type CommandNode_<S> = CommandNode<S>;
    abstract class UnmodifiableIterator <E> implements Internal.Iterator<E> {
        /**
         * @deprecated
        */
        remove(): void;
        forEachRemaining(arg0: Internal.Consumer_<E>): void;
        abstract next(): E;
        abstract hasNext(): boolean;
    }
    type UnmodifiableIterator_<E> = UnmodifiableIterator<E>;
    interface Long2ObjectMap <V> extends Internal.Map<number, V>, Internal.Long2ObjectFunction<V> {
        replace(arg0: number, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        abstract containsValue(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        remove(arg0: number): V;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        keySet(): Internal.Set<any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        computeIfAbsent(arg0: number, arg1: Internal.LongFunction_<V>): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        composeLong(arg0: Internal.Long2LongFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        entrySet(): Internal.Set<any>;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        apply(arg0: number): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        abstract putAll(arg0: Internal.Map_<number, V>): void;
        abstract containsKey(arg0: number): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        abstract defaultReturnValue(): V;
        getOrDefault(arg0: number, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        remove(arg0: number, arg1: any): boolean;
        abstract defaultReturnValue(arg0: V): void;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        of<K, V>(): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        /**
         * @deprecated
        */
        computeIfAbsentPartial(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        computeIfAbsent(arg0: number, arg1: Internal.Long2ObjectFunction_<V>): V;
        put(arg0: number, arg1: V): V;
        apply(arg0: number): V;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        remove(arg0: any, arg1: any): boolean;
        abstract values(): Internal.ObjectCollection<V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        abstract get(arg0: number): V;
        abstract size(): number;
        abstract hashCode(): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        replace(arg0: number, arg1: V): V;
        abstract long2ObjectEntrySet(): Internal.ObjectSet<Internal.Long2ObjectMap$Entry<V>>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        abstract equals(arg0: any): boolean;
        putIfAbsent(arg0: number, arg1: V): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        get empty(): boolean
    }
    type Long2ObjectMap_<V> = Long2ObjectMap<V>;
    class ClickEvent implements Internal.JsonSerializable {
        constructor($$0: Internal.ClickEvent$Action_, $$1: string)
        getValue(): string;
        toJson(): Internal.JsonElement;
        getAction(): Internal.ClickEvent$Action;
        get value(): string
        get action(): Internal.ClickEvent$Action
    }
    type ClickEvent_ = ClickEvent;
    interface EntityTrackerAccessor {
        abstract getPlayersTracking(): Internal.Set<Internal.ServerPlayerConnection>;
        get playersTracking(): Internal.Set<Internal.ServerPlayerConnection>
        (): Internal.Set_<Internal.ServerPlayerConnection>;
    }
    type EntityTrackerAccessor_ = EntityTrackerAccessor;
    interface Object2ObjectMap$Entry <K, V> extends Internal.Map$Entry<K, V> {
        abstract getKey(): K;
        comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract hashCode(): number;
        copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract getValue(): V;
        comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract equals(arg0: any): boolean;
        abstract setValue(arg0: V): V;
        get key(): K
        get value(): V
        set value(arg0: V)
    }
    type Object2ObjectMap$Entry_<K, V> = Object2ObjectMap$Entry<K, V>;
    abstract class NumericSingleLineDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type NumericSingleLineDisplaySource_ = NumericSingleLineDisplaySource;
    class ByteTag extends Internal.NumericTag {
        static valueOf($$0: number): Internal.ByteTag;
        getAsString(): string;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        static valueOf($$0: boolean): Internal.ByteTag;
        getType(): Internal.TagType<Internal.ByteTag>;
        copy(): this;
        get asString(): string
        get type(): Internal.TagType<Internal.ByteTag>
        static readonly ONE: Internal.ByteTag;
        static readonly ZERO: Internal.ByteTag;
        static readonly TYPE: Internal.TagType<Internal.ByteTag>;
    }
    type ByteTag_ = ByteTag;
    class JobAttributes implements Internal.Cloneable {
        constructor()
        constructor(arg0: number, arg1: Internal.JobAttributes$DefaultSelectionType_, arg2: Internal.JobAttributes$DestinationType_, arg3: Internal.JobAttributes$DialogType_, arg4: string, arg5: number, arg6: number, arg7: Internal.JobAttributes$MultipleDocumentHandlingType_, arg8: number[][], arg9: string, arg10: Internal.JobAttributes$SidesType_)
        constructor(arg0: Internal.JobAttributes_)
        clone(): any;
        setMaxPage(arg0: number): void;
        setPrinter(arg0: string): void;
        getSides(): Internal.JobAttributes$SidesType;
        getPageRanges(): number[][];
        setFileName(arg0: string): void;
        setSides(arg0: Internal.JobAttributes$SidesType_): void;
        getCopies(): number;
        setToPage(arg0: number): void;
        setCopiesToDefault(): void;
        setMultipleDocumentHandlingToDefault(): void;
        getFileName(): string;
        getDefaultSelection(): Internal.JobAttributes$DefaultSelectionType;
        setDefaultSelection(arg0: Internal.JobAttributes$DefaultSelectionType_): void;
        set(arg0: Internal.JobAttributes_): void;
        setFromPage(arg0: number): void;
        getDestination(): Internal.JobAttributes$DestinationType;
        setDialog(arg0: Internal.JobAttributes$DialogType_): void;
        setSidesToDefault(): void;
        setCopies(arg0: number): void;
        setMinPage(arg0: number): void;
        getFromPage(): number;
        getToPage(): number;
        getMultipleDocumentHandling(): Internal.JobAttributes$MultipleDocumentHandlingType;
        setPageRanges(arg0: number[][]): void;
        getMinPage(): number;
        getMaxPage(): number;
        setDestination(arg0: Internal.JobAttributes$DestinationType_): void;
        setMultipleDocumentHandling(arg0: Internal.JobAttributes$MultipleDocumentHandlingType_): void;
        getDialog(): Internal.JobAttributes$DialogType;
        getPrinter(): string;
        set maxPage(arg0: number)
        set printer(arg0: string)
        get sides(): Internal.JobAttributes$SidesType
        get pageRanges(): number[][]
        set fileName(arg0: string)
        set sides(arg0: Internal.JobAttributes$SidesType_)
        get copies(): number
        set toPage(arg0: number)
        get fileName(): string
        get defaultSelection(): Internal.JobAttributes$DefaultSelectionType
        set defaultSelection(arg0: Internal.JobAttributes$DefaultSelectionType_)
        set fromPage(arg0: number)
        get destination(): Internal.JobAttributes$DestinationType
        set dialog(arg0: Internal.JobAttributes$DialogType_)
        set copies(arg0: number)
        set minPage(arg0: number)
        get fromPage(): number
        get toPage(): number
        get multipleDocumentHandling(): Internal.JobAttributes$MultipleDocumentHandlingType
        set pageRanges(arg0: number[][])
        get minPage(): number
        get maxPage(): number
        set destination(arg0: Internal.JobAttributes$DestinationType_)
        set multipleDocumentHandling(arg0: Internal.JobAttributes$MultipleDocumentHandlingType_)
        get dialog(): Internal.JobAttributes$DialogType
        get printer(): string
    }
    type JobAttributes_ = JobAttributes;
    class GlowLichenBlock extends Internal.MultifaceBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static emission($$0: number): Internal.ToIntFunction<Internal.BlockState>;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type GlowLichenBlock_ = GlowLichenBlock;
    class ModCheck extends Internal.Record {
        constructor($$0: Internal.ModCheck$Confidence_, $$1: string)
        shouldReportAsModified(): boolean;
        fullDescription(): string;
        static identify($$0: string, $$1: Internal.Supplier_<string>, $$2: string, $$3: typeof any): Internal.ModCheck;
        description(): string;
        confidence(): Internal.ModCheck$Confidence;
        merge($$0: Internal.ModCheck_): this;
    }
    type ModCheck_ = ModCheck;
    interface ItemBuilder$FinishUsingCallback {
        abstract finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        (arg0: Internal.ItemStack, arg1: Internal.Level, arg2: Internal.LivingEntity): Internal.ItemStack_;
    }
    type ItemBuilder$FinishUsingCallback_ = ItemBuilder$FinishUsingCallback;
    class PlayerDataStorage {
        constructor($$0: Internal.LevelStorageSource$LevelStorageAccess_, $$1: Internal.DataFixer_)
        load($$0: Internal.Player_): Internal.CompoundTag;
        handler$fgn000$owo$onPlayerDataSaved(player: Internal.Player_, ci: Internal.CallbackInfo_, tag: Internal.CompoundTag_): void;
        getSeenPlayers(): string[];
        save($$0: Internal.Player_): void;
        get seenPlayers(): string[]
    }
    type PlayerDataStorage_ = PlayerDataStorage;
    interface Int2IntFunction extends Internal.IntUnaryOperator, it.unimi.dsi.fastutil.Function<number, number> {
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2IntFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Int2FloatFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2IntFunction;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        apply(arg0: number): number;
        containsKey(arg0: number): boolean;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2IntFunction<T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2IntFunction<T>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Int2ByteFunction;
        getOrDefault(arg0: number, arg1: number): number;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        applyAsInt(arg0: number): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Int2DoubleFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2IntFunction;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Int2CharFunction;
        put(arg0: number, arg1: number): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Int2LongFunction;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Int2ShortFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        size(): number;
        defaultReturnValue(arg0: number): void;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2IntFunction;
        clear(): void;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2IntFunction;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        identity(): this;
        (arg0: number): number;
    }
    type Int2IntFunction_ = Int2IntFunction;
    class EndPortalBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type EndPortalBlock_ = EndPortalBlock;
    interface IntegerValueInvoker {
        invokeCreate(defaultValue: number, onChanged: Internal.BiConsumer_<Internal.MinecraftServer, Internal.GameRules$IntegerValue>): Internal.GameRules$Type<Internal.GameRules$IntegerValue>;
    }
    type IntegerValueInvoker_ = IntegerValueInvoker;
    class MemoryStack extends Internal.Pointer$Default implements Internal.AutoCloseable {
        clongs(...arg0: number[]): Internal.CLongBuffer;
        push(): this;
        shorts(arg0: number, arg1: number, arg2: number): Internal.ShortBuffer;
        static stackCallocDouble(arg0: number): Internal.DoubleBuffer;
        ncalloc(arg0: number, arg1: number, arg2: number): number;
        pointers(arg0: Internal.Buffer_, arg1: Internal.Buffer_, arg2: Internal.Buffer_, arg3: Internal.Buffer_): Internal.PointerBuffer;
        floats(...arg0: number[]): Internal.FloatBuffer;
        static stackFloats(arg0: number): Internal.FloatBuffer;
        calloc(arg0: number, arg1: number): Internal.ByteBuffer;
        nclong(arg0: number): number;
        static nstackMalloc(arg0: number): number;
        static stackPush(): Internal.MemoryStack;
        bytes(arg0: number, arg1: number, arg2: number, arg3: number): Internal.ByteBuffer;
        malloc(arg0: number, arg1: number): Internal.ByteBuffer;
        ndouble(arg0: number): number;
        longs(arg0: number, arg1: number): Internal.LongBuffer;
        static stackCLongs(arg0: number, arg1: number): Internal.CLongBuffer;
        ASCIISafe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        getSize(): number;
        pointers(arg0: number, arg1: number, arg2: number, arg3: number): Internal.PointerBuffer;
        static stackMallocInt(arg0: number): Internal.IntBuffer;
        ASCIISafe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        UTF16(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static stackPointers(arg0: number, arg1: number, arg2: number, arg3: number): Internal.PointerBuffer;
        static stackCallocFloat(arg0: number): Internal.FloatBuffer;
        ints(arg0: number): Internal.IntBuffer;
        static stackLongs(arg0: number): Internal.LongBuffer;
        static stackInts(arg0: number): Internal.IntBuffer;
        static stackCLongs(arg0: number, arg1: number, arg2: number): Internal.CLongBuffer;
        ints(arg0: number, arg1: number, arg2: number, arg3: number): Internal.IntBuffer;
        static stackMallocFloat(arg0: number): Internal.FloatBuffer;
        UTF16(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static create(arg0: Internal.ByteBuffer_): Internal.MemoryStack;
        static stackCallocShort(arg0: number): Internal.ShortBuffer;
        ASCII(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        shorts(arg0: number): Internal.ShortBuffer;
        doubles(arg0: number, arg1: number): Internal.DoubleBuffer;
        npointer(arg0: Internal.Buffer_): number;
        pointers(arg0: Internal.Buffer_, arg1: Internal.Buffer_, arg2: Internal.Buffer_): Internal.PointerBuffer;
        mallocInt(arg0: number): Internal.IntBuffer;
        bytes(...arg0: number[]): Internal.ByteBuffer;
        pointers(...arg0: number[]): Internal.PointerBuffer;
        static stackDoubles(arg0: number): Internal.DoubleBuffer;
        static stackUTF16Safe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        nUTF8Safe(arg0: Internal.CharSequence_, arg1: boolean): number;
        static stackShorts(arg0: number): Internal.ShortBuffer;
        pointers(...arg0: Internal.Buffer_[]): Internal.PointerBuffer;
        static stackUTF16(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static stackDoubles(arg0: number, arg1: number, arg2: number): Internal.DoubleBuffer;
        callocDouble(arg0: number): Internal.DoubleBuffer;
        longs(arg0: number, arg1: number, arg2: number): Internal.LongBuffer;
        static stackCalloc(arg0: number): Internal.ByteBuffer;
        getFrameIndex(): number;
        static stackCLongs(arg0: number, arg1: number, arg2: number, arg3: number): Internal.CLongBuffer;
        nlong(arg0: number): number;
        clongs(arg0: number, arg1: number, arg2: number, arg3: number): Internal.CLongBuffer;
        callocCLong(arg0: number): Internal.CLongBuffer;
        static stackFloats(...arg0: number[]): Internal.FloatBuffer;
        pointers(arg0: Internal.Pointer_): Internal.PointerBuffer;
        static stackShorts(arg0: number, arg1: number, arg2: number): Internal.ShortBuffer;
        static stackUTF16Safe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        UTF16Safe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static ncreate(arg0: number, arg1: number): Internal.MemoryStack;
        UTF8Safe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static stackUTF8(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static stackBytes(...arg0: number[]): Internal.ByteBuffer;
        clongs(arg0: number, arg1: number, arg2: number): Internal.CLongBuffer;
        static stackMallocShort(arg0: number): Internal.ShortBuffer;
        static stackCLongs(arg0: number): Internal.CLongBuffer;
        static stackBytes(arg0: number, arg1: number): Internal.ByteBuffer;
        UTF8Safe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        nmalloc(arg0: number, arg1: number): number;
        static stackCallocCLong(arg0: number): Internal.CLongBuffer;
        static nstackCalloc(arg0: number, arg1: number, arg2: number): number;
        ints(...arg0: number[]): Internal.IntBuffer;
        nASCII(arg0: Internal.CharSequence_, arg1: boolean): number;
        static stackPointers(arg0: number, arg1: number): Internal.PointerBuffer;
        npointer(arg0: Internal.Pointer_): number;
        static stackInts(arg0: number, arg1: number, arg2: number, arg3: number): Internal.IntBuffer;
        static stackDoubles(arg0: number, arg1: number): Internal.DoubleBuffer;
        static stackPointers(...arg0: Internal.Pointer_[]): Internal.PointerBuffer;
        getPointer(): number;
        UTF8(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static stackShorts(arg0: number, arg1: number, arg2: number, arg3: number): Internal.ShortBuffer;
        longs(arg0: number, arg1: number, arg2: number, arg3: number): Internal.LongBuffer;
        mallocCLong(arg0: number): Internal.CLongBuffer;
        floats(arg0: number, arg1: number, arg2: number): Internal.FloatBuffer;
        setPointer(arg0: number): void;
        bytes(arg0: number, arg1: number, arg2: number): Internal.ByteBuffer;
        static stackPointers(arg0: number, arg1: number, arg2: number): Internal.PointerBuffer;
        static stackASCIISafe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        static stackPop(): Internal.MemoryStack;
        bytes(arg0: number): Internal.ByteBuffer;
        pointers(arg0: number): Internal.PointerBuffer;
        mallocFloat(arg0: number): Internal.FloatBuffer;
        clongs(arg0: number, arg1: number): Internal.CLongBuffer;
        callocShort(arg0: number): Internal.ShortBuffer;
        static stackDoubles(...arg0: number[]): Internal.DoubleBuffer;
        static nstackMalloc(arg0: number, arg1: number): number;
        getPointerAddress(): number;
        pointers(arg0: number, arg1: number, arg2: number): Internal.PointerBuffer;
        static stackASCIISafe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static stackCallocLong(arg0: number): Internal.LongBuffer;
        mallocLong(arg0: number): Internal.LongBuffer;
        pointers(arg0: Internal.Buffer_): Internal.PointerBuffer;
        pointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_, arg2: Internal.Pointer_, arg3: Internal.Pointer_): Internal.PointerBuffer;
        static stackShorts(...arg0: number[]): Internal.ShortBuffer;
        calloc(arg0: number): Internal.ByteBuffer;
        static stackCallocInt(arg0: number): Internal.IntBuffer;
        pointers(...arg0: Internal.Pointer_[]): Internal.PointerBuffer;
        nUTF16(arg0: Internal.CharSequence_, arg1: boolean): number;
        static stackASCII(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        callocFloat(arg0: number): Internal.FloatBuffer;
        static stackASCII(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        pointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_): Internal.PointerBuffer;
        static stackLongs(arg0: number, arg1: number, arg2: number): Internal.LongBuffer;
        nUTF16Safe(arg0: Internal.CharSequence_, arg1: boolean): number;
        getAddress(): number;
        ints(arg0: number, arg1: number): Internal.IntBuffer;
        static stackCLongs(...arg0: number[]): Internal.CLongBuffer;
        longs(...arg0: number[]): Internal.LongBuffer;
        static stackBytes(arg0: number): Internal.ByteBuffer;
        static stackBytes(arg0: number, arg1: number, arg2: number): Internal.ByteBuffer;
        callocPointer(arg0: number): Internal.PointerBuffer;
        static stackPointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_, arg2: Internal.Pointer_): Internal.PointerBuffer;
        mallocPointer(arg0: number): Internal.PointerBuffer;
        npointer(arg0: number): number;
        floats(arg0: number, arg1: number): Internal.FloatBuffer;
        static stackFloats(arg0: number, arg1: number, arg2: number, arg3: number): Internal.FloatBuffer;
        static stackPointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_): Internal.PointerBuffer;
        static stackShorts(arg0: number, arg1: number): Internal.ShortBuffer;
        pointers(arg0: Internal.Buffer_, arg1: Internal.Buffer_): Internal.PointerBuffer;
        static stackPointers(arg0: Internal.Pointer_): Internal.PointerBuffer;
        static stackPointers(...arg0: number[]): Internal.PointerBuffer;
        malloc(arg0: number): Internal.ByteBuffer;
        ints(arg0: number, arg1: number, arg2: number): Internal.IntBuffer;
        static stackPointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_, arg2: Internal.Pointer_, arg3: Internal.Pointer_): Internal.PointerBuffer;
        static stackMallocDouble(arg0: number): Internal.DoubleBuffer;
        shorts(arg0: number, arg1: number): Internal.ShortBuffer;
        static stackGet(): Internal.MemoryStack;
        static stackInts(arg0: number, arg1: number): Internal.IntBuffer;
        static create(arg0: number): Internal.MemoryStack;
        static stackDoubles(arg0: number, arg1: number, arg2: number, arg3: number): Internal.DoubleBuffer;
        callocInt(arg0: number): Internal.IntBuffer;
        doubles(arg0: number): Internal.DoubleBuffer;
        mallocDouble(arg0: number): Internal.DoubleBuffer;
        UTF8(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static stackMallocLong(arg0: number): Internal.LongBuffer;
        floats(arg0: number, arg1: number, arg2: number, arg3: number): Internal.FloatBuffer;
        static stackLongs(arg0: number, arg1: number): Internal.LongBuffer;
        nint(arg0: number): number;
        static stackFloats(arg0: number, arg1: number): Internal.FloatBuffer;
        static stackMallocCLong(arg0: number): Internal.CLongBuffer;
        static stackUTF8Safe(arg0: Internal.CharSequence_, arg1: boolean): Internal.ByteBuffer;
        clongs(arg0: number): Internal.CLongBuffer;
        callocLong(arg0: number): Internal.LongBuffer;
        doubles(arg0: number, arg1: number, arg2: number): Internal.DoubleBuffer;
        pointers(arg0: number, arg1: number): Internal.PointerBuffer;
        static stackBytes(arg0: number, arg1: number, arg2: number, arg3: number): Internal.ByteBuffer;
        floats(arg0: number): Internal.FloatBuffer;
        static stackMalloc(arg0: number): Internal.ByteBuffer;
        nUTF8(arg0: Internal.CharSequence_, arg1: boolean): number;
        nASCIISafe(arg0: Internal.CharSequence_, arg1: boolean): number;
        longs(arg0: number): Internal.LongBuffer;
        pointers(arg0: Internal.Pointer_, arg1: Internal.Pointer_, arg2: Internal.Pointer_): Internal.PointerBuffer;
        static stackCallocPointer(arg0: number): Internal.PointerBuffer;
        static stackUTF8Safe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static stackUTF16(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        nshort(arg0: number): number;
        static stackInts(arg0: number, arg1: number, arg2: number): Internal.IntBuffer;
        nmalloc(arg0: number): number;
        pop(): this;
        static stackLongs(...arg0: number[]): Internal.LongBuffer;
        doubles(arg0: number, arg1: number, arg2: number, arg3: number): Internal.DoubleBuffer;
        static stackPointers(arg0: number): Internal.PointerBuffer;
        static stackLongs(arg0: number, arg1: number, arg2: number, arg3: number): Internal.LongBuffer;
        mallocShort(arg0: number): Internal.ShortBuffer;
        static stackInts(...arg0: number[]): Internal.IntBuffer;
        UTF16Safe(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        static stackMallocPointer(arg0: number): Internal.PointerBuffer;
        nbyte(arg0: number): number;
        shorts(...arg0: number[]): Internal.ShortBuffer;
        static stackUTF8(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        shorts(arg0: number, arg1: number, arg2: number, arg3: number): Internal.ShortBuffer;
        doubles(...arg0: number[]): Internal.DoubleBuffer;
        nfloat(arg0: number): number;
        close(): void;
        static create(): Internal.MemoryStack;
        static stackFloats(arg0: number, arg1: number, arg2: number): Internal.FloatBuffer;
        ASCII(arg0: Internal.CharSequence_): Internal.ByteBuffer;
        bytes(arg0: number, arg1: number): Internal.ByteBuffer;
        get size(): number
        get frameIndex(): number
        get pointer(): number
        set pointer(arg0: number)
        get pointerAddress(): number
        get address(): number
    }
    type MemoryStack_ = MemoryStack;
    interface IGrid {
        abstract postEvent<T extends Internal.GridEvent>(arg0: T): T;
        abstract getActiveMachines<T>(arg0: T): Internal.Set<T>;
        getStorageService(): Internal.IStorageService;
        abstract getMachines<T>(arg0: T): Internal.Set<T>;
        getEnergyService(): Internal.IEnergyService;
        abstract getService<C extends Internal.IGridService>(arg0: C): C;
        abstract isEmpty(): boolean;
        getTickManager(): Internal.ITickManager;
        abstract getMachineClasses(): Internal.Iterable<typeof any>;
        abstract getNodes(): Internal.Iterable<Internal.IGridNode>;
        getSpatialService(): Internal.ISpatialService;
        abstract size(): number;
        getPathingService(): Internal.IPathingService;
        getCraftingService(): Internal.ICraftingService;
        abstract getMachineNodes(arg0: typeof any): Internal.Iterable<Internal.IGridNode>;
        abstract getPivot(): Internal.IGridNode;
        get storageService(): Internal.IStorageService
        get energyService(): Internal.IEnergyService
        get empty(): boolean
        get tickManager(): Internal.ITickManager
        get machineClasses(): Internal.Iterable<typeof any>
        get nodes(): Internal.Iterable<Internal.IGridNode>
        get spatialService(): Internal.ISpatialService
        get pathingService(): Internal.IPathingService
        get craftingService(): Internal.ICraftingService
        get pivot(): Internal.IGridNode
    }
    type IGrid_ = IGrid;
    class LocalTime implements Internal.Comparable<Internal.LocalTime>, Internal.Temporal, Internal.TemporalAdjuster, Internal.Serializable {
        getHour(): number;
        plus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        minusMinutes(arg0: number): this;
        static parse(arg0: Internal.CharSequence_, arg1: Internal.DateTimeFormatter_): Internal.LocalTime;
        minusSeconds(arg0: number): this;
        compareTo(arg0: any): number;
        isBefore(arg0: Internal.LocalTime_): boolean;
        getMinute(): number;
        static parse(arg0: Internal.CharSequence_): Internal.LocalTime;
        toSecondOfDay(): number;
        plusHours(arg0: number): this;
        minus(arg0: Internal.TemporalAmount_): this;
        isSupported(arg0: Internal.TemporalField_): boolean;
        format(arg0: Internal.DateTimeFormatter_): string;
        "with"(arg0: Internal.TemporalAdjuster_): this;
        isAfter(arg0: Internal.LocalTime_): boolean;
        withMinute(arg0: number): this;
        plusNanos(arg0: number): this;
        static ofInstant(arg0: Internal.Instant_, arg1: Internal.ZoneId_): Internal.LocalTime;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        get(arg0: Internal.TemporalField_): number;
        minusHours(arg0: number): this;
        compareTo(arg0: Internal.LocalTime_): number;
        toEpochSecond(arg0: Internal.LocalDate_, arg1: Internal.ZoneOffset_): number;
        withNano(arg0: number): this;
        static from(arg0: Internal.TemporalAccessor_): Internal.LocalTime;
        plus(arg0: Internal.TemporalAmount_): this;
        plusMinutes(arg0: number): this;
        plusSeconds(arg0: number): this;
        static ofNanoOfDay(arg0: number): Internal.LocalTime;
        static now(arg0: Internal.ZoneId_): Internal.LocalTime;
        getLong(arg0: Internal.TemporalField_): number;
        withSecond(arg0: number): this;
        atDate(arg0: Internal.LocalDate_): Internal.LocalDateTime;
        static of(arg0: number, arg1: number, arg2: number, arg3: number): Internal.LocalTime;
        minus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        toNanoOfDay(): number;
        static ofSecondOfDay(arg0: number): Internal.LocalTime;
        truncatedTo(arg0: Internal.TemporalUnit_): this;
        static now(arg0: Internal.Clock_): Internal.LocalTime;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        static of(arg0: number, arg1: number): Internal.LocalTime;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        minusNanos(arg0: number): this;
        atOffset(arg0: Internal.ZoneOffset_): Internal.OffsetTime;
        static now(): Internal.LocalTime;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        getNano(): number;
        getSecond(): number;
        "with"(arg0: Internal.TemporalField_, arg1: number): this;
        static of(arg0: number, arg1: number, arg2: number): Internal.LocalTime;
        withHour(arg0: number): this;
        get hour(): number
        get minute(): number
        get nano(): number
        get second(): number
        static readonly MAX: Internal.LocalTime;
        static readonly NOON: Internal.LocalTime;
        static readonly MIDNIGHT: Internal.LocalTime;
        static readonly MIN: Internal.LocalTime;
    }
    type LocalTime_ = LocalTime;
    class ChannelAccess$ChannelHandle {
        constructor($$0: any_, $$1: com.mojang.blaze3d.audio.Channel_)
        isStopped(): boolean;
        release(): void;
        execute($$0: Internal.Consumer_<com.mojang.blaze3d.audio.Channel>): void;
        get stopped(): boolean
    }
    type ChannelAccess$ChannelHandle_ = ChannelAccess$ChannelHandle;
    class WallBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
        static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
        static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
        static readonly UP: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    }
    type WallBlock_ = WallBlock;
    class ModuleDescriptor$Requires$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Requires$Modifier> {
        static values(): Internal.ModuleDescriptor$Requires$Modifier[];
        static valueOf(arg0: string): Internal.ModuleDescriptor$Requires$Modifier;
        static readonly STATIC: Internal.ModuleDescriptor$Requires$Modifier;
        static readonly MANDATED: Internal.ModuleDescriptor$Requires$Modifier;
        static readonly TRANSITIVE: Internal.ModuleDescriptor$Requires$Modifier;
        static readonly SYNTHETIC: Internal.ModuleDescriptor$Requires$Modifier;
    }
    type ModuleDescriptor$Requires$Modifier_ = ModuleDescriptor$Requires$Modifier | "static" | "mandated" | "transitive" | "synthetic";
    abstract class FocusTraversalPolicy {
        abstract getLastComponent(arg0: Internal.Container_): Internal.Component;
        abstract getComponentAfter(arg0: Internal.Container_, arg1: Internal.Component_): Internal.Component;
        abstract getComponentBefore(arg0: Internal.Container_, arg1: Internal.Component_): Internal.Component;
        abstract getDefaultComponent(arg0: Internal.Container_): Internal.Component;
        getInitialComponent(arg0: Internal.Window_): Internal.Component;
        abstract getFirstComponent(arg0: Internal.Container_): Internal.Component;
    }
    type FocusTraversalPolicy_ = FocusTraversalPolicy;
    interface IAEItemPowerStorage {
        abstract extractAEPower(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Actionable_): number;
        abstract injectAEPower(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Actionable_): number;
        abstract getPowerFlow(arg0: Internal.ItemStack_): Internal.AccessRestriction;
        abstract getChargeRate(arg0: Internal.ItemStack_): number;
        abstract getAECurrentPower(arg0: Internal.ItemStack_): number;
        abstract getAEMaxPower(arg0: Internal.ItemStack_): number;
    }
    type IAEItemPowerStorage_ = IAEItemPowerStorage;
    class Couple <T> extends net.createmod.catnip.data.Pair<T, T> implements Internal.Iterable<T> {
        replaceWithContext(function_: Internal.BiFunction_<T, boolean, T>): void;
        set(first: boolean, value: T): void;
        mapNotNull<S>(function_: Internal.Function_<T, S>): Internal.Couple<S>;
        spliterator(): Internal.Spliterator<T>;
        replace(function_: Internal.Function_<T, T>): void;
        both(test: Internal.Predicate_<T>): boolean;
        iterator(): Internal.Iterator<T>;
        static deserializeEach<S>(list: Internal.ListTag_, deserializer: Internal.Function_<Internal.CompoundTag, S>): Internal.Couple<S>;
        forEach(consumer: Internal.Consumer_<T>): void;
        map<S>(function_: Internal.Function_<T, S>): Internal.Couple<S>;
        serializeEach(serializer: Internal.Function_<T, Internal.CompoundTag>): Internal.ListTag;
        mapWithParams<S, R>(function_: Internal.BiFunction_<T, R, S>, values: Internal.Couple_<R>): Internal.Couple<S>;
        forEachWithContext(consumer: Internal.BiConsumer_<T, boolean>): void;
        replaceWithParams<S>(function_: Internal.BiFunction_<T, S, T>, values: Internal.Couple_<S>): void;
        stream(): Internal.Stream<T>;
        static create<T>(factory: Internal.Supplier_<T>): Internal.Couple<T>;
        get(first: boolean): T;
        copy(): net.createmod.catnip.data.Pair<any, any>;
        mapNotNullWithParam<S, R>(function_: Internal.BiFunction_<T, R, S>, value: R): Internal.Couple<S>;
        mapWithContext<S>(function_: Internal.BiFunction_<T, boolean, S>): Internal.Couple<S>;
        swap(): this;
        either(test: Internal.Predicate_<T>): boolean;
        static create<T>(first: T, second: T): Internal.Couple<T>;
        forEachWithParams<S>(function_: Internal.BiConsumer_<T, S>, values: Internal.Couple_<S>): void;
        static createWithContext<T>(factory: Internal.Function_<boolean, T>): Internal.Couple<T>;
    }
    type Couple_<T> = Couple<T>;
    interface IAssemblyRecipe {
        abstract getDescriptionForAssembly(): net.minecraft.network.chat.Component;
        abstract getJEISubCategory(): Internal.SequencedAssemblySubCategoryType;
        supportsAssembly(): boolean;
        abstract addRequiredMachines(arg0: Internal.Set_<Internal.ItemLike>): void;
        addAssemblyFluidIngredients(list: Internal.List_<Internal.FluidIngredient>): void;
        abstract addAssemblyIngredients(arg0: Internal.List_<Internal.Ingredient>): void;
        get descriptionForAssembly(): net.minecraft.network.chat.Component
        get JEISubCategory(): Internal.SequencedAssemblySubCategoryType
    }
    type IAssemblyRecipe_ = IAssemblyRecipe;
    class WaterPumpBlock extends Internal.MachineBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SHAPE_NORTH: Internal.ArrayVoxelShape;
        static readonly SHAPE_SOUTH: Internal.ArrayVoxelShape;
        static readonly SHAPE_WEST: Internal.ArrayVoxelShape;
        static readonly SHAPE_EAST: Internal.ArrayVoxelShape;
    }
    type WaterPumpBlock_ = WaterPumpBlock;
    class XpEgg extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type XpEgg_ = XpEgg;
    interface BogeyRenderer {
        abstract render(arg0: Internal.CompoundTag_, arg1: number, arg2: number, arg3: Internal.PoseStack_, arg4: Internal.MultiBufferSource_, arg5: number, arg6: number, arg7: boolean): void;
        (arg0: Internal.CompoundTag, arg1: number, arg2: number, arg3: Internal.PoseStack, arg4: Internal.MultiBufferSource, arg5: number, arg6: number, arg7: boolean): void;
    }
    type BogeyRenderer_ = BogeyRenderer;
    abstract class StructureProcessor implements Internal.StructureProcessorExtensions {
        constructor()
        processEntity(world: Internal.LevelReader_, seedPos: BlockPos_, rawEntityInfo: Internal.StructureTemplate$StructureEntityInfo_, entityInfo: Internal.StructureTemplate$StructureEntityInfo_, placementSettings: Internal.StructurePlaceSettings_, template: Internal.StructureTemplate_): Internal.StructureTemplate$StructureEntityInfo;
        processBlock($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: BlockPos_, $$3: Internal.StructureTemplate$StructureBlockInfo_, $$4: Internal.StructureTemplate$StructureBlockInfo_, $$5: Internal.StructurePlaceSettings_): Internal.StructureTemplate$StructureBlockInfo;
        finalizeProcessing($$0: Internal.ServerLevelAccessor_, $$1: BlockPos_, $$2: BlockPos_, $$3: Internal.List_<Internal.StructureTemplate$StructureBlockInfo>, $$4: Internal.List_<Internal.StructureTemplate$StructureBlockInfo>, $$5: Internal.StructurePlaceSettings_): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
    }
    type StructureProcessor_ = StructureProcessor;
    class CogWheelBlock extends Internal.AbstractSimpleShaftBlock implements Internal.ICogWheel, Internal.EncasableBlock {
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.KineticBlockEntity;
        tryRemoveBracket(context: Internal.UseOnContext_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSmallCog(): boolean;
        playEncaseSound(level: Internal.Level_, pos: BlockPos_): void;
        tryEncase(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): Internal.InteractionResult;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static large(properties: Internal.BlockBehaviour$Properties_): Internal.CogWheelBlock;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        isLargeCog(): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCogItem(test: Internal.ItemStack_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static isLargeCog(state: Internal.BlockState_): boolean;
        isDedicatedCogWheel(): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static isLargeCogItem(test: Internal.ItemStack_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        static isValidCogwheelPosition(large: boolean, worldIn: Internal.LevelReader_, pos: BlockPos_, cogAxis: Internal.Direction$Axis_): boolean;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCog(state: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        static isLargeCog(block: Internal.Block_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static small(properties: Internal.BlockBehaviour$Properties_): Internal.CogWheelBlock;
        static isDedicatedCogWheel(block: Internal.Block_): boolean;
        static isSmallCog(block: Internal.Block_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        static isDedicatedCogItem(test: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        get smallCog(): boolean
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get largeCog(): boolean
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get dedicatedCogWheel(): boolean
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type CogWheelBlock_ = CogWheelBlock;
    class CartAssemblerBlock$MinecartAnchorBlock extends Internal.Block {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CartAssemblerBlock$MinecartAnchorBlock_ = CartAssemblerBlock$MinecartAnchorBlock;
    interface CustomRenderBoundingBoxBlockEntity {
        getInfiniteBoundingBox(): Internal.AABB;
        self(): Internal.BlockEntity;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        readonly INFINITE_EXTENT_AABB: Internal.AABB;
    }
    type CustomRenderBoundingBoxBlockEntity_ = CustomRenderBoundingBoxBlockEntity;
    class ComplexDouble {
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        arg(): number;
        sqrt(): this;
        inv(): this;
        mul(arg0: Internal.ComplexDouble_): this;
        conj(): this;
        isZero(): boolean;
        addi(arg0: number): this;
        muli(arg0: Internal.ComplexDouble_): this;
        invi(): this;
        subi(arg0: Internal.ComplexDouble_): this;
        divi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDouble_): this;
        set(arg0: number, arg1: number): this;
        divi(arg0: number, arg1: Internal.ComplexDouble_): this;
        sub(arg0: Internal.ComplexDouble_): this;
        divi(arg0: Internal.ComplexDouble_): this;
        negi(): this;
        add(arg0: number): this;
        abs(): number;
        addi(arg0: number, arg1: Internal.ComplexDouble_): this;
        isReal(): boolean;
        muli(arg0: number, arg1: Internal.ComplexDouble_): this;
        neg(): this;
        addi(arg0: Internal.ComplexDouble_): this;
        ne(arg0: Internal.ComplexDouble_): boolean;
        imag(): number;
        add(arg0: Internal.ComplexDouble_): this;
        div(arg0: Internal.ComplexDouble_): this;
        divi(arg0: number): this;
        mul(arg0: number): this;
        addi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDouble_): this;
        eq(arg0: Internal.ComplexDouble_): boolean;
        real(): number;
        subi(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDouble_): this;
        div(arg0: number): this;
        subi(arg0: number, arg1: Internal.ComplexDouble_): this;
        subi(arg0: number): this;
        muli(arg0: Internal.ComplexDouble_, arg1: Internal.ComplexDouble_): this;
        isImag(): boolean;
        copy(arg0: Internal.ComplexDouble_): this;
        muli(arg0: number): this;
        conji(): this;
        dup(): this;
        sub(arg0: number): this;
        get zero(): boolean
        get real(): boolean
        get imag(): boolean
        static readonly NEG_I: Internal.ComplexDouble;
        static readonly UNIT: Internal.ComplexDouble;
        static readonly ZERO: Internal.ComplexDouble;
        static readonly I: Internal.ComplexDouble;
        static readonly NEG_UNIT: Internal.ComplexDouble;
    }
    type ComplexDouble_ = ComplexDouble;
    class BackstabbingEnchantment extends Internal.Enchantment implements Internal.CustomEnchantingTableBehaviorEnchantment {
        constructor(rarity: Internal.Enchantment$Rarity_, category: Internal.EnchantmentCategory_, ...applicableSlots: Internal.EquipmentSlot_[])
        static getBackstabbingDamagePerLevel(amount: number, level: number): number;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_): boolean;
        static isLookingBehindTarget(target: Internal.LivingEntity_, attackerLocation: Vec3d_): boolean;
    }
    type BackstabbingEnchantment_ = BackstabbingEnchantment;
    class TileExInterface extends Internal.InterfaceBlockEntity implements Internal.IPage {
        constructor(pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setPage(page: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getConfig(): Internal.GenericStackInv;
        asComponentProvider(): Internal.ComponentProvider;
        getStorage(): Internal.GenericStackInv;
        hasCustomName(): boolean;
        getPage(): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getUpgrades(): Internal.IUpgradeInventory;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        set page(page: number)
        get gridNode(): Internal.IGridNode
        get config(): Internal.GenericStackInv
        get storage(): Internal.GenericStackInv
        get page(): number
        get actionableNode(): Internal.IGridNode
        get upgrades(): Internal.IUpgradeInventory
        set owner(owner: Internal.Player_)
    }
    type TileExInterface_ = TileExInterface;
    interface RegistrarBuilder <T> {
        abstract build(): Internal.Registrar<T>;
        saveToDisc(): this;
        abstract option(arg0: Internal.RegistrarOption_): this;
        syncToClients(): this;
    }
    type RegistrarBuilder_<T> = RegistrarBuilder<T>;
    class BigDripleafStemBlock extends Internal.HorizontalDirectionalBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BigDripleafStemBlock_ = BigDripleafStemBlock;
    class ModuleDescriptor$Requires implements Internal.Comparable<Internal.ModuleDescriptor$Requires> {
        name(): string;
        compareTo(arg0: Internal.ModuleDescriptor$Requires_): number;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        rawCompiledVersion(): Internal.Optional<string>;
        compiledVersion(): Internal.Optional<Internal.ModuleDescriptor$Version>;
        compareTo(arg0: any): number;
        modifiers(): Internal.Set<Internal.ModuleDescriptor$Requires$Modifier>;
    }
    type ModuleDescriptor$Requires_ = ModuleDescriptor$Requires;
    class BrigadierExceptions implements Internal.BuiltInExceptionProvider {
        constructor()
        dispatcherParseException(): Internal.DynamicCommandExceptionType;
        readerExpectedInt(): Internal.SimpleCommandExceptionType;
        floatTooLow(): Internal.Dynamic2CommandExceptionType;
        readerInvalidBool(): Internal.DynamicCommandExceptionType;
        readerInvalidEscape(): Internal.DynamicCommandExceptionType;
        readerInvalidLong(): Internal.DynamicCommandExceptionType;
        readerInvalidDouble(): Internal.DynamicCommandExceptionType;
        readerInvalidInt(): Internal.DynamicCommandExceptionType;
        integerTooLow(): Internal.Dynamic2CommandExceptionType;
        longTooLow(): Internal.Dynamic2CommandExceptionType;
        floatTooHigh(): Internal.Dynamic2CommandExceptionType;
        readerExpectedLong(): Internal.SimpleCommandExceptionType;
        dispatcherUnknownCommand(): Internal.SimpleCommandExceptionType;
        integerTooHigh(): Internal.Dynamic2CommandExceptionType;
        readerExpectedFloat(): Internal.SimpleCommandExceptionType;
        longTooHigh(): Internal.Dynamic2CommandExceptionType;
        readerExpectedSymbol(): Internal.DynamicCommandExceptionType;
        readerExpectedEndOfQuote(): Internal.SimpleCommandExceptionType;
        doubleTooHigh(): Internal.Dynamic2CommandExceptionType;
        doubleTooLow(): Internal.Dynamic2CommandExceptionType;
        readerExpectedStartOfQuote(): Internal.SimpleCommandExceptionType;
        dispatcherUnknownArgument(): Internal.SimpleCommandExceptionType;
        readerExpectedBool(): Internal.SimpleCommandExceptionType;
        literalIncorrect(): Internal.DynamicCommandExceptionType;
        readerInvalidFloat(): Internal.DynamicCommandExceptionType;
        readerExpectedDouble(): Internal.SimpleCommandExceptionType;
        dispatcherExpectedArgumentSeparator(): Internal.SimpleCommandExceptionType;
    }
    type BrigadierExceptions_ = BrigadierExceptions;
    interface DragGestureListener extends Internal.EventListener {
        abstract dragGestureRecognized(arg0: Internal.DragGestureEvent_): void;
        (arg0: Internal.DragGestureEvent): void;
    }
    type DragGestureListener_ = DragGestureListener;
    class BlockLookingImpetus extends Internal.BlockAbstractImpetus {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockLookingImpetus_ = BlockLookingImpetus;
    class LeaveVineDecorator extends Internal.TreeDecorator {
        constructor($$0: number)
        static readonly CODEC: Internal.Codec<Internal.LeaveVineDecorator>;
    }
    type LeaveVineDecorator_ = LeaveVineDecorator;
    interface BlockRenderDispatcherAccessor {
        abstract getBlockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer;
        get blockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer
        (): Internal.BlockEntityWithoutLevelRenderer_;
    }
    type BlockRenderDispatcherAccessor_ = BlockRenderDispatcherAccessor;
    interface Char2BooleanFunction extends it.unimi.dsi.fastutil.Function<string, boolean>, Internal.IntPredicate {
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, boolean>;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2BooleanFunction;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2BooleanFunction;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        or(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        negate(): Internal.IntPredicate;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2BooleanFunction<T>;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: boolean): boolean;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2BooleanFunction;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Char2IntFunction;
        containsKey(arg0: string): boolean;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2BooleanFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Char2ShortFunction;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        get(arg0: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): boolean;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Char2FloatFunction;
        apply(arg0: string): boolean;
        and(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        put(arg0: string, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Char2CharFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<string, T>;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2BooleanFunction<T>;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Char2LongFunction;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2BooleanFunction;
        size(): number;
        abstract get(arg0: string): boolean;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2BooleanFunction;
        clear(): void;
        remove(arg0: string): boolean;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: boolean): void;
        getOrDefault(arg0: string, arg1: boolean): boolean;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Char2DoubleFunction;
        (arg0: string): boolean;
    }
    type Char2BooleanFunction_ = Char2BooleanFunction;
    class CreativeTabBuilder extends Internal.BuilderBase<Internal.CreativeModeTab> {
        constructor(i: ResourceLocation_)
        content(content: Internal.CreativeTabContentSupplier_): this;
        createObject(): any;
        icon(icon: Internal.CreativeTabIconSupplier_): this;
    }
    type CreativeTabBuilder_ = CreativeTabBuilder;
    class ClientLevel$ClientLevelData implements Internal.ComponentProvider, Internal.WritableLevelData {
        constructor($$0: Internal.Difficulty_, $$1: boolean, $$2: boolean)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_, $$1: Internal.LevelHeightAccessor_): void;
        isRaining(): boolean;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getSpawnAngle(): number;
        setRaining($$0: boolean): void;
        getGameRules(): Internal.GameRules;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getHorizonHeight($$0: Internal.LevelHeightAccessor_): number;
        isHardcore(): boolean;
        getYSpawn(): number;
        getGameTime(): number;
        getZSpawn(): number;
        getXSpawn(): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getDifficulty(): Internal.Difficulty;
        isThundering(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        isDifficultyLocked(): boolean;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        setDayTime($$0: number): void;
        setXSpawn($$0: number): void;
        getClearColorScale(): number;
        setDifficulty($$0: Internal.Difficulty_): void;
        setZSpawn($$0: number): void;
        setYSpawn($$0: number): void;
        setDifficultyLocked($$0: boolean): void;
        setSpawn($$0: BlockPos_, $$1: number): void;
        getComponentContainer(): Internal.ComponentContainer;
        setSpawnAngle($$0: number): void;
        getDayTime(): number;
        setGameTime($$0: number): void;
        get raining(): boolean
        get spawnAngle(): number
        set raining($$0: boolean)
        get gameRules(): Internal.GameRules
        get hardcore(): boolean
        get YSpawn(): number
        get gameTime(): number
        get ZSpawn(): number
        get XSpawn(): number
        get difficulty(): Internal.Difficulty
        get thundering(): boolean
        get difficultyLocked(): boolean
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        set dayTime($$0: number)
        set XSpawn($$0: number)
        get clearColorScale(): number
        set difficulty($$0: Internal.Difficulty_)
        set ZSpawn($$0: number)
        set YSpawn($$0: number)
        set difficultyLocked($$0: boolean)
        get componentContainer(): Internal.ComponentContainer
        set spawnAngle($$0: number)
        get dayTime(): number
        set gameTime($$0: number)
    }
    type ClientLevel$ClientLevelData_ = ClientLevel$ClientLevelData;
    class RepeatArgumentType$Info implements Internal.ArgumentTypeInfo<Internal.RepeatArgumentType<any, any>, Internal.RepeatArgumentType$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToJson(arg: Internal.RepeatArgumentType$Template_, json: Internal.JsonObject_): void;
        serializeToNetwork(arg: Internal.RepeatArgumentType$Template_, buf: Internal.FriendlyByteBuf_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        deserializeFromNetwork(buf: Internal.FriendlyByteBuf_): Internal.RepeatArgumentType$Template;
        unpack(argumentType: Internal.RepeatArgumentType_<any, any>): Internal.RepeatArgumentType$Template;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type RepeatArgumentType$Info_ = RepeatArgumentType$Info;
    class ItemHippocampusSlapper extends Internal.SwordItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemHippocampusSlapper_ = ItemHippocampusSlapper;
    interface BaseStream <T, S extends Internal.BaseStream<T, S>> extends Internal.AutoCloseable {
        abstract onClose(arg0: Internal.Runnable_): S;
        abstract unordered(): S;
        abstract isParallel(): boolean;
        abstract close(): void;
        abstract parallel(): S;
        abstract spliterator(): Internal.Spliterator<T>;
        abstract sequential(): S;
        abstract iterator(): Internal.Iterator<T>;
        get parallel(): boolean
    }
    type BaseStream_<T, S extends Internal.BaseStream<T, S>> = BaseStream<T, S>;
    interface Clearable {
        tryClear($$0: any): void;
        abstract clearContent(): void;
        (): void;
    }
    type Clearable_ = Clearable;
    class EnchantmentTableBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        handler$zbi000$porting_lib_base$port_lib$particles(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_, var5: Internal.Iterator_<any>, blockPos: BlockPos_): void;
        static isValidBookShelf($$0: Internal.Level_, $$1: BlockPos_, $$2: BlockPos_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly BOOKSHELF_OFFSETS: [BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos, BlockPos];
    }
    type EnchantmentTableBlock_ = EnchantmentTableBlock;
    interface RenderTargetExtensions {
        disableStencil(): void;
        enableStencil(): void;
        isStencilEnabled(): boolean;
        get stencilEnabled(): boolean
    }
    type RenderTargetExtensions_ = RenderTargetExtensions;
    class Camera implements Internal.CameraAccessor, Internal.CameraExtensions {
        constructor()
        getMaxZoom($$0: number): number;
        getLeftVector(): Vec3f;
        setAnglesInternal(yaw: number, pitch: number): void;
        rotation(): Quaternionf;
        getPosition(): Vec3d;
        getLookVector(): Vec3f;
        getNearPlane(): Internal.Camera$NearPlane;
        "handler$hgf000$sodium-extra$noLerp"(ci: Internal.CallbackInfo_): void;
        getXRot(): number;
        tick(): void;
        getFluidInCamera(): Internal.FogType;
        getBlockAtCamera(): Internal.BlockState;
        setup($$0: Internal.BlockGetter_, $$1: Internal.Entity_, $$2: boolean, $$3: boolean, $$4: number): void;
        move($$0: number, $$1: number, $$2: number): void;
        getEntity(): Internal.Entity;
        getYRot(): number;
        isDetached(): boolean;
        isInitialized(): boolean;
        getUpVector(): Vec3f;
        reset(): void;
        setDetached(arg0: boolean): void;
        getBlockPosition(): BlockPos;
        handler$zji000$ad_astra$adastra$update(area: Internal.BlockGetter_, focusedEntity: Internal.Entity_, thirdPerson: boolean, inverseView: boolean, tickDelta: number, ci: Internal.CallbackInfo_): void;
        get leftVector(): Vec3f
        get position(): Vec3d
        get lookVector(): Vec3f
        get nearPlane(): Internal.Camera$NearPlane
        get XRot(): number
        get fluidInCamera(): Internal.FogType
        get blockAtCamera(): Internal.BlockState
        get entity(): Internal.Entity
        get YRot(): number
        get detached(): boolean
        get initialized(): boolean
        get upVector(): Vec3f
        set detached(arg0: boolean)
        get blockPosition(): BlockPos
        static readonly FOG_DISTANCE_SCALE: 0.083333336;
    }
    type Camera_ = Camera;
    class VibrationSystem$Listener implements Internal.GameEventListener {
        constructor($$0: Internal.VibrationSystem_)
        forceScheduleVibration($$0: Internal.ServerLevel_, $$1: Internal.GameEvent_, $$2: Internal.GameEvent$Context_, $$3: Vec3d_): void;
        static distanceBetweenInBlocks($$0: BlockPos_, $$1: BlockPos_): number;
        getListenerSource(): Internal.PositionSource;
        getListenerRadius(): number;
        handleGameEvent($$0: Internal.ServerLevel_, $$1: Internal.GameEvent_, $$2: Internal.GameEvent$Context_, $$3: Vec3d_): boolean;
        getDeliveryMode(): Internal.GameEventListener$DeliveryMode;
        get listenerSource(): Internal.PositionSource
        get listenerRadius(): number
        get deliveryMode(): Internal.GameEventListener$DeliveryMode
    }
    type VibrationSystem$Listener_ = VibrationSystem$Listener;
    class EncasedPipeBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.BlockPickInteractionAware, Internal.IBE<Internal.FluidPipeBlockEntity>, Internal.EncasedBlock, Internal.SpecialBlockItemRequirement, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, casing: Internal.Supplier_<Internal.Block>)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getCasing(): Internal.Block;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FluidPipeBlockEntity;
        setRequiresTool(v: boolean): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FluidPipeBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.FluidPipeBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, view: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        static transferSixWayProperties(from: Internal.BlockState_, to: Internal.BlockState_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FluidPipeBlockEntity>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FluidPipeBlockEntity>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        handleEncasing(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): void;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FluidPipeBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get casing(): Internal.Block
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.FluidPipeBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.FluidPipeBlockEntity
        set destroySpeed(v: number)
        static readonly FACING_TO_PROPERTY_MAP: {[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty};
    }
    type EncasedPipeBlock_ = EncasedPipeBlock;
    abstract class AbstractDragonPhaseInstance implements Internal.DragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        doClientTick(): void;
        onHurt($$0: DamageSource_, $$1: number): number;
        isSitting(): boolean;
        getFlyTargetLocation(): Vec3d;
        end(): void;
        getFlySpeed(): number;
        getTurnSpeed(): number;
        abstract getPhase(): Internal.EnderDragonPhase<Internal.DragonPhaseInstance>;
        onCrystalDestroyed($$0: Internal.EndCrystal_, $$1: BlockPos_, $$2: DamageSource_, $$3: Internal.Player_): void;
        begin(): void;
        doServerTick(): void;
        get sitting(): boolean
        get flyTargetLocation(): Vec3d
        get flySpeed(): number
        get turnSpeed(): number
        get phase(): Internal.EnderDragonPhase<Internal.DragonPhaseInstance>
    }
    type AbstractDragonPhaseInstance_ = AbstractDragonPhaseInstance;
    class Blender$BlendingOutput extends Internal.Record {
        constructor($$0: number, $$1: number)
        blendingOffset(): number;
        alpha(): number;
    }
    type Blender$BlendingOutput_ = Blender$BlendingOutput;
    class SmithingTemplateItem extends Internal.Item {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_, $$3: net.minecraft.network.chat.Component_, $$4: net.minecraft.network.chat.Component_, $$5: Internal.List_<ResourceLocation>, $$6: Internal.List_<ResourceLocation>)
        static createNetheriteUpgradeIconList(): Internal.List<ResourceLocation>;
        static createArmorTrimTemplate($$0: Internal.ResourceKey_<Internal.TrimPattern>): Internal.SmithingTemplateItem;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        static createNetheriteUpgradeMaterialList(): Internal.List<ResourceLocation>;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static createNetheriteUpgradeTemplate(): Internal.SmithingTemplateItem;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static createArmorTrimTemplate($$0: ResourceLocation_): Internal.SmithingTemplateItem;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getBaseSlotDescription(): net.minecraft.network.chat.Component;
        static createTrimmableArmorIconList(): Internal.List<ResourceLocation>;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getAdditionSlotDescription(): net.minecraft.network.chat.Component;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static createTrimmableMaterialIconList(): Internal.List<ResourceLocation>;
        emi(amount: number): Internal.EmiStack;
        getAdditionalSlotEmptyIcons(): Internal.List<ResourceLocation>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getBaseSlotEmptyIcons(): Internal.List<ResourceLocation>;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get baseSlotDescription(): net.minecraft.network.chat.Component
        get additionSlotDescription(): net.minecraft.network.chat.Component
        get additionalSlotEmptyIcons(): Internal.List<ResourceLocation>
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get baseSlotEmptyIcons(): Internal.List<ResourceLocation>
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly NETHERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION: Internal.MutableComponent;
        static readonly EMPTY_SLOT_EMERALD: ResourceLocation;
        static readonly EMPTY_SLOT_SHOVEL: ResourceLocation;
        static readonly EMPTY_SLOT_AMETHYST_SHARD: ResourceLocation;
        static readonly DESCRIPTION_FORMAT: Internal.ChatFormatting;
        static readonly NETHERITE_UPGRADE_INGREDIENTS: Internal.MutableComponent;
        static readonly NETHERITE_UPGRADE_BASE_SLOT_DESCRIPTION: Internal.MutableComponent;
        static readonly ARMOR_TRIM_BASE_SLOT_DESCRIPTION: Internal.MutableComponent;
        static readonly TITLE_FORMAT: Internal.ChatFormatting;
        static readonly APPLIES_TO_TITLE: Internal.MutableComponent;
        static readonly NETHERITE_UPGRADE: Internal.MutableComponent;
        static readonly ARMOR_TRIM_ADDITIONS_SLOT_DESCRIPTION: Internal.MutableComponent;
        static readonly EMPTY_SLOT_HELMET: ResourceLocation;
        static readonly EMPTY_SLOT_BOOTS: ResourceLocation;
        static readonly EMPTY_SLOT_PICKAXE: ResourceLocation;
        static readonly EMPTY_SLOT_DIAMOND: ResourceLocation;
        static readonly ARMOR_TRIM_INGREDIENTS: Internal.MutableComponent;
        static readonly ARMOR_TRIM_APPLIES_TO: Internal.MutableComponent;
        static readonly NETHERITE_UPGRADE_APPLIES_TO: Internal.MutableComponent;
        static readonly EMPTY_SLOT_SWORD: ResourceLocation;
        static readonly EMPTY_SLOT_REDSTONE_DUST: ResourceLocation;
        static readonly EMPTY_SLOT_AXE: ResourceLocation;
        static readonly EMPTY_SLOT_LEGGINGS: ResourceLocation;
        static readonly EMPTY_SLOT_LAPIS_LAZULI: ResourceLocation;
        static readonly EMPTY_SLOT_HOE: ResourceLocation;
        static readonly EMPTY_SLOT_QUARTZ: ResourceLocation;
        static readonly EMPTY_SLOT_INGOT: ResourceLocation;
        static readonly INGREDIENTS_TITLE: Internal.MutableComponent;
        static readonly EMPTY_SLOT_CHESTPLATE: ResourceLocation;
    }
    type SmithingTemplateItem_ = SmithingTemplateItem;
    class CypressTreeFeature extends Internal.BOPTreeFeature<Internal.CypressTreeConfiguration> {
        constructor(codec: Internal.Codec_<Internal.CypressTreeConfiguration>)
        generateLeafLayer(world: Internal.LevelAccessor_, pos: BlockPos_, radius: number, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.CypressTreeConfiguration_): void;
        radius(height: number, maxHeight: number): number;
        checkSpace(world: Internal.LevelAccessor_, pos: BlockPos_, baseHeight: number, height: number): boolean;
    }
    type CypressTreeFeature_ = CypressTreeFeature;
    class BlockEntityJS extends Internal.BlockEntity {
        constructor(blockPos: BlockPos_, blockState: Internal.BlockState_, entityInfo: Internal.BlockEntityInfo_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        sendEvent(eventId: number, data: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        save(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        sync(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        get block(): Internal.BlockContainerJS
        cycle: number;
        readonly attachments: any[];
        readonly z: number;
        placerId: Internal.UUID;
        readonly x: number;
        readonly y: number;
        tick: number;
        inventory: Internal.InventoryKJS;
        readonly info: Internal.BlockEntityInfo;
        data: Internal.CompoundTag;
    }
    type BlockEntityJS_ = BlockEntityJS;
    class GameConfig {
        constructor($$0: Internal.GameConfig$UserData_, $$1: Internal.DisplayData_, $$2: Internal.GameConfig$FolderData_, $$3: Internal.GameConfig$GameData_, $$4: Internal.GameConfig$QuickPlayData_)
        readonly user: Internal.GameConfig$UserData;
        readonly location: Internal.GameConfig$FolderData;
        readonly display: Internal.DisplayData;
        readonly quickPlay: Internal.GameConfig$QuickPlayData;
        readonly game: Internal.GameConfig$GameData;
    }
    type GameConfig_ = GameConfig;
    interface PocketUpgradeSerialiser <T extends Internal.IPocketUpgrade> extends Internal.UpgradeSerialiser<T> {
        registryId(): Internal.ResourceKey<Internal.Registry<Internal.PocketUpgradeSerialiser<any>>>;
        simpleWithCustomItem<T extends Internal.IPocketUpgrade>(factory: Internal.BiFunction_<ResourceLocation, Internal.ItemStack, T>): this;
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): T;
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): T;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        simple<T extends Internal.IPocketUpgrade>(factory: Internal.Function_<ResourceLocation, T>): this;
    }
    type PocketUpgradeSerialiser_<T extends Internal.IPocketUpgrade> = Special.PocketUpgradeSerialiser | PocketUpgradeSerialiser<T>;
    class ItemWirelessConnectTool extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemWirelessConnectTool_ = ItemWirelessConnectTool;
    class RiceBaleBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getFlammability(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, face: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, face: Internal.Direction_): number;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type RiceBaleBlock_ = RiceBaleBlock;
    class PerlinSimplexNoise {
        constructor($$0: Internal.RandomSource_, $$1: Internal.List_<number>)
        getValue($$0: number, $$1: number, $$2: boolean): number;
    }
    type PerlinSimplexNoise_ = PerlinSimplexNoise;
    class MultiPlayerGameMode {
        constructor($$0: Internal.Minecraft_, $$1: Internal.ClientPacketListener_)
        "handler$ceg000$fabric-events-interaction-v0$interactBlock"(player: Internal.LocalPlayer_, hand: Internal.InteractionHand_, blockHitResult: Internal.BlockHitResult_, info: Internal.CallbackInfoReturnable_<any>): void;
        adjustPlayer($$0: Internal.Player_): void;
        useItemOn($$0: Internal.LocalPlayer_, $$1: Internal.InteractionHand_, $$2: Internal.BlockHitResult_): Internal.InteractionResult;
        modifyReceiver$zfp000$porting_lib_base$port_lib$bypassBlockUse(result: Internal.BlockState_, level: Internal.Level_, player: Internal.Player_, hand: Internal.InteractionHand_, blockHitResult: Internal.BlockHitResult_): Internal.BlockState;
        stopDestroyBlock(): void;
        "handler$ceg000$fabric-events-interaction-v0$method_2902"(pos: BlockPos_, direction: Internal.Direction_, info: Internal.CallbackInfoReturnable_<any>): void;
        createPlayer($$0: Internal.ClientLevel_, $$1: Internal.StatsCounter_, $$2: Internal.ClientRecipeBook_, $$3: boolean, $$4: boolean): Internal.LocalPlayer;
        createPlayer($$0: Internal.ClientLevel_, $$1: Internal.StatsCounter_, $$2: Internal.ClientRecipeBook_): Internal.LocalPlayer;
        interact($$0: Internal.Player_, $$1: Internal.Entity_, $$2: Internal.InteractionHand_): Internal.InteractionResult;
        handler$ggi000$porting_lib_entity$port_lib$onEntityInteract(player: Internal.Player_, target: Internal.Entity_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        interactAt($$0: Internal.Player_, $$1: Internal.Entity_, $$2: Internal.EntityHitResult_, $$3: Internal.InteractionHand_): Internal.InteractionResult;
        handlePickItem($$0: number): void;
        hasExperience(): boolean;
        hasFarPickRange(): boolean;
        handler$zfp000$porting_lib_base$port_lib$playerDestroyBlock(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>, level: Internal.Level_, blockstate: Internal.BlockState_, block: Internal.Block_, fluidstate: Internal.FluidState_): void;
        handleCreativeModeItemDrop($$0: Internal.ItemStack_): void;
        handler$ggi000$porting_lib_entity$port_lib$startDestroy(loc: BlockPos_, face: Internal.Direction_, cir: Internal.CallbackInfoReturnable_<any>): void;
        hasMissTime(): boolean;
        "handler$ceg000$fabric-events-interaction-v0$attackEntity"(player: Internal.Player_, entity: Internal.Entity_, info: Internal.CallbackInfo_): void;
        canHurtPlayer(): boolean;
        hasInfiniteItems(): boolean;
        isDestroying(): boolean;
        useItem($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        handler$zfp000$porting_lib_base$port_lib$useItemOn(player: Internal.LocalPlayer_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getPlayerMode(): Internal.GameType;
        handleInventoryButtonClick($$0: number, $$1: number): void;
        "handler$ceg000$fabric-events-interaction-v0$interactItem"(player: Internal.Player_, hand: Internal.InteractionHand_, info: Internal.CallbackInfoReturnable_<any>): void;
        handler$zfp001$porting_lib_base$port_lib$destroyBlock(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        attack($$0: Internal.Player_, $$1: Internal.Entity_): void;
        getPreviousPlayerMode(): Internal.GameType;
        setLocalMode($$0: Internal.GameType_, $$1: Internal.GameType_): void;
        handlePlaceRecipe($$0: number, $$1: Internal.Recipe_<any>, $$2: boolean): void;
        tick(): void;
        getDestroyStage(): number;
        getPickRange(): number;
        "handler$ceg000$fabric-events-interaction-v0$attackBlock"(pos: BlockPos_, direction: Internal.Direction_, info: Internal.CallbackInfoReturnable_<any>): void;
        continueDestroyBlock($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        releaseUsingItem($$0: Internal.Player_): void;
        handleInventoryMouseClick($$0: number, $$1: number, $$2: number, $$3: Internal.ClickType_, $$4: Internal.Player_): void;
        isServerControlledInventory(): boolean;
        handleCreativeModeItemAdd($$0: Internal.ItemStack_, $$1: number): void;
        destroyBlock($$0: BlockPos_): boolean;
        startDestroyBlock($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        isAlwaysFlying(): boolean;
        setLocalMode($$0: Internal.GameType_): void;
        get destroying(): boolean
        get playerMode(): Internal.GameType
        get previousPlayerMode(): Internal.GameType
        get destroyStage(): number
        get pickRange(): number
        get serverControlledInventory(): boolean
        get alwaysFlying(): boolean
        set localMode($$0: Internal.GameType_)
        destroyDelay: number;
        destroyProgress: number;
        destroyBlockPos: BlockPos;
    }
    type MultiPlayerGameMode_ = MultiPlayerGameMode;
    class Subscription extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.Subscription;
        startDate: number;
        daysLeft: number;
        type: Internal.Subscription$SubscriptionType;
    }
    type Subscription_ = Subscription;
    class RenderSystem$AutoStorageIndexBuffer {
        hasStorage($$0: number): boolean;
        bind($$0: number): void;
        type(): Internal.VertexFormat$IndexType;
    }
    type RenderSystem$AutoStorageIndexBuffer_ = RenderSystem$AutoStorageIndexBuffer;
    interface Long2IntFunction extends Internal.LongToIntFunction, it.unimi.dsi.fastutil.Function<number, number> {
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2IntFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        abstract get(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2IntFunction<T>;
        getOrDefault(arg0: number, arg1: number): number;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Long2FloatFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2IntFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        applyAsInt(arg0: number): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Long2ShortFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Long2ByteFunction;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Long2LongFunction;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2IntFunction;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2IntFunction;
        remove(arg0: number): number;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2IntFunction;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        size(): number;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2IntFunction;
        defaultReturnValue(arg0: number): void;
        apply(arg0: number): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Long2CharFunction;
        clear(): void;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Long2DoubleFunction;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2IntFunction;
        identity<T>(): Internal.Function<T, T>;
        (arg0: number): number;
    }
    type Long2IntFunction_ = Long2IntFunction;
    abstract class StemGrownBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        abstract getAttachedStem(): Internal.AttachedStemBlock;
        abstract getStem(): Internal.StemBlock;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get attachedStem(): Internal.AttachedStemBlock
        get stem(): Internal.StemBlock
        set lightEmission(v: number)
        get mod(): string
    }
    type StemGrownBlock_ = StemGrownBlock;
    class MobSpawnSettings$SpawnerData extends Internal.WeightedEntry$IntrusiveBase {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Weight_, $$2: number, $$3: number)
        constructor($$0: Internal.EntityType_<any>, $$1: number, $$2: number, $$3: number)
        static wrap<T>($$0: T, $$1: number): Internal.WeightedEntry$Wrapper<T>;
        readonly minCount: number;
        static readonly CODEC: Internal.Codec<Internal.MobSpawnSettings$SpawnerData>;
        readonly type: Internal.EntityType<any>;
        readonly maxCount: number;
    }
    type MobSpawnSettings$SpawnerData_ = MobSpawnSettings$SpawnerData;
    class FarmBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static turnToDirt($$0: Internal.Entity_, $$1: Internal.BlockState_, $$2: Internal.Level_, $$3: BlockPos_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MAX_MOISTURE: 7;
        static readonly MOISTURE: Internal.IntegerProperty;
    }
    type FarmBlock_ = FarmBlock;
    interface RarityFilterAccessor {
        abstract getChance(): number;
        get chance(): number
        (): number;
    }
    type RarityFilterAccessor_ = RarityFilterAccessor;
}
declare namespace dev.lambdaurora.lambdynlights.mixin {
    interface LevelRendererAccessor {
        abstract lambdynlights$scheduleChunkRebuild(arg0: number, arg1: number, arg2: number, arg3: boolean): void;
        (arg0: number, arg1: number, arg2: number, arg3: boolean): void;
    }
    type LevelRendererAccessor_ = LevelRendererAccessor;
}
declare namespace org.slf4j.event {
    class Level extends Internal.Enum<org.slf4j.event.Level> {
        static valueOf(arg0: string): org.slf4j.event.Level;
        static values(): org.slf4j.event.Level[];
        toInt(): number;
        static intToLevel(arg0: number): org.slf4j.event.Level;
        static readonly WARN: org.slf4j.event.Level;
        static readonly TRACE: org.slf4j.event.Level;
        static readonly ERROR: org.slf4j.event.Level;
        static readonly INFO: org.slf4j.event.Level;
        static readonly DEBUG: org.slf4j.event.Level;
    }
    type Level_ = "warn" | "trace" | "error" | "debug" | Level | "info";
}
declare namespace software.bernie.geckolib.core.animation {
    class AnimationState <T extends Internal.GeoAnimatable> {
        constructor(animatable: T, limbSwing: number, limbSwingAmount: number, partialTick: number, isMoving: boolean)
        withController(controller: Internal.AnimationController_<T>): this;
        getPartialTick(): number;
        isMoving(): boolean;
        getController(): Internal.AnimationController<T>;
        getExtraData(): Internal.Map<Internal.DataTicket<any>, any>;
        getLimbSwing(): number;
        getData<D>(dataTicket: Internal.DataTicket_<D>): D;
        getAnimatable(): T;
        getLimbSwingAmount(): number;
        isCurrentAnimation(animation: Internal.RawAnimation_): boolean;
        setControllerSpeed(speed: number): void;
        getAnimationTick(): number;
        setAndContinue(animation: Internal.RawAnimation_): Internal.PlayState;
        isCurrentAnimationStage(name: string): boolean;
        setAnimation(animation: Internal.RawAnimation_): void;
        setData<D>(dataTicket: Internal.DataTicket_<D>, data: D): void;
        resetCurrentAnimation(): void;
        get partialTick(): number
        get moving(): boolean
        get controller(): Internal.AnimationController<T>
        get extraData(): Internal.Map<Internal.DataTicket<any>, any>
        get limbSwing(): number
        get animatable(): T
        get limbSwingAmount(): number
        set controllerSpeed(speed: number)
        get animationTick(): number
        set andContinue(animation: Internal.RawAnimation_)
        set animation(animation: Internal.RawAnimation_)
        animationTick: number;
    }
    type AnimationState_<T extends Internal.GeoAnimatable> = AnimationState<T>;
}
